/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.listener.event;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.enhancera.accesslog.common.CommonContentType;
import com.enhancera.accesslog.common.ContentType;
import com.enhancera.accesslog.confluence.ConfluenceContentType;
import java.util.Date;
import javax.annotation.Nullable;

public class ConfluenceContentEntity {
    private final long id;
    @Nullable
    private final String title;
    private final int version;
    private final long latestVersionId;
    @Nullable
    private final String spaceKey;
    private final Date creationDate;
    private final String urlPath;
    @Nullable
    private final ContentType contentType;
    private final long attachmentContainerId;

    public ConfluenceContentEntity(ContentEntityObject contentEntityObject) {
        this.id = contentEntityObject.getId();
        this.title = this.getTitle(contentEntityObject);
        this.version = contentEntityObject.getVersion();
        this.latestVersionId = contentEntityObject.getLatestVersionId();
        this.spaceKey = this.getSpaceKey(contentEntityObject);
        this.creationDate = contentEntityObject.getCreationDate();
        this.urlPath = contentEntityObject.getUrlPath();
        this.contentType = this.getContentType(contentEntityObject);
        this.attachmentContainerId = this.getContainerId(contentEntityObject);
    }

    private long getContainerId(ContentEntityObject contentEntityObject) {
        if (contentEntityObject instanceof Attachment) {
            Attachment attachment = (Attachment)contentEntityObject;
            return attachment.getContainer().getId();
        }
        return 0L;
    }

    @Nullable
    private String getTitle(ContentEntityObject contentEntityObject) {
        if (contentEntityObject instanceof Comment) {
            Comment comment = (Comment)contentEntityObject;
            Comment commentLastVersion = (Comment)comment.getLatestVersion();
            return commentLastVersion.getContainer().getTitle();
        }
        return contentEntityObject.getTitle();
    }

    @Nullable
    private String getSpaceKey(ContentEntityObject contentEntityObject) {
        if (contentEntityObject instanceof SpaceContentEntityObject) {
            SpaceContentEntityObject spaceContentEntityObject = (SpaceContentEntityObject)contentEntityObject;
            return spaceContentEntityObject.getSpaceKey();
        }
        if (contentEntityObject instanceof Comment) {
            Comment comment = (Comment)contentEntityObject;
            return comment.getSpace().getKey();
        }
        return null;
    }

    @Nullable
    private ContentType getContentType(ContentEntityObject contentEntityObject) {
        Enum resultContentType = null;
        ContentTypeEnum contentTypeEnum = contentEntityObject.getTypeEnum();
        if (contentTypeEnum == null) {
            return null;
        }
        switch (contentTypeEnum) {
            case BLOG: {
                resultContentType = ConfluenceContentType.BLOG_POST;
                break;
            }
            case PAGE: {
                resultContentType = ConfluenceContentType.PAGE;
                break;
            }
            case COMMENT: {
                resultContentType = CommonContentType.COMMENT;
                break;
            }
            case ATTACHMENT: {
                resultContentType = CommonContentType.ATTACHMENT;
                break;
            }
        }
        return resultContentType;
    }

    public long getId() {
        return this.id;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public int getVersion() {
        return this.version;
    }

    public long getLatestVersionId() {
        return this.latestVersionId;
    }

    @Nullable
    public String getSpaceKey() {
        return this.spaceKey;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    @Nullable
    public ContentType getContentType() {
        return this.contentType;
    }

    public long getAttachmentContainerId() {
        return this.attachmentContainerId;
    }

    public String getContainerIdAsString() {
        return Long.toString(this.getAttachmentContainerId());
    }

    public String getLatestVersionIdAsString() {
        return Long.toString(this.getLatestVersionId());
    }
}

