/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.servlet;

import au.com.bytecode.opencsv.CSVWriter;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.enhancera.accesslog.HostAppService;
import com.enhancera.accesslog.common.RecordCriteria;
import com.enhancera.accesslog.common.database.DataLayer;
import com.enhancera.accesslog.common.rest.AccessRecordApi;
import com.enhancera.accesslog.common.servlet.GenericHttpRequest;
import com.enhancera.accesslog.common.servlet.GenericHttpResponse;
import com.enhancera.accesslog.common.servlet.GlobalAccessServletRedirectExecutor;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.LicenseCheckResult;
import com.enhancera.accesslog.common.util.LicenseChecker;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.common.util.UserRedirect;
import com.enhancera.accesslog.common.util.UserUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

public class CsvExportServletExecutor {
    private static final String DATE_TIME_FORMAT = "yyyyMMdd-HHmmss";
    private static final String FILE_NAME_FORMAT = "%s-access-log-%s.csv";
    private static final String CONTENT_TYPE = "text/csv;charset=UTF-8";
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    private static final String CONTENT_DISPOSITION_VALUE_FORMAT = "attachment; filename=\"%s\"";
    private static final FormattingLogger log = FormattingLogger.getLogger(CsvExportServletExecutor.class);
    private static final String[] CSV_HEADER = new String[]{"Time", "User", "Ip Address", "Content Type", "Content Id", "Action"};
    private final DataLayer dataLayer;
    private final I18nResolver i18nResolver;
    private final UserUtils userUtils;
    private final LicenseChecker licenseChecker;
    private final HostAppService hostAppService;
    private final UserRedirect userRedirect;
    private final GlobalAccessServletRedirectExecutor globalAccessServletRedirectExecutor;

    public CsvExportServletExecutor(DataLayer dataLayer, I18nResolver i18nResolver, UserUtils userUtils, HostAppService hostAppService, PluginLicenseManager pluginLicenseManager, UserRedirect userRedirect, GlobalAccessServletRedirectExecutor globalAccessServletRedirectExecutor) {
        this.dataLayer = dataLayer;
        this.i18nResolver = i18nResolver;
        this.userUtils = userUtils;
        this.licenseChecker = new LicenseChecker(pluginLicenseManager, i18nResolver);
        this.hostAppService = hostAppService;
        this.userRedirect = userRedirect;
        this.globalAccessServletRedirectExecutor = globalAccessServletRedirectExecutor;
    }

    public void doGet(GenericHttpRequest request, GenericHttpResponse response) {
        try {
            this.globalAccessServletRedirectExecutor.redirectIfNotAccessible(request, response);
            if (this.userRedirect.redirectIfNotAllowed(request, response)) {
                return;
            }
            response.setContentType(CONTENT_TYPE);
            String filename = String.format(FILE_NAME_FORMAT, this.hostAppService.getApplicationName(), DateTimeFormat.forPattern(DATE_TIME_FORMAT).print(DateTime.now()));
            response.setHeader(CONTENT_DISPOSITION_HEADER, String.format(CONTENT_DISPOSITION_VALUE_FORMAT, filename));
            PrintWriter printWriter = response.getWriter();
            printWriter.print('\ufeff');
            try (CSVWriter writer = new CSVWriter(printWriter);){
                LicenseCheckResult licenseCheckResult = this.licenseChecker.checkLicense();
                if (!licenseCheckResult.isOk()) {
                    log.error("Access logging disabled due to the following reason: %s", licenseCheckResult.getMessage());
                    writer.writeNext(new String[]{licenseCheckResult.getMessage()});
                } else {
                    String[] sortParams = request.getParameterValues("sortParams");
                    writer.writeNext(CSV_HEADER);
                    this.dataLayer.readRecords(RecordCriteria.create(request), RequestUtils.parseSortParams(sortParams != null ? Arrays.asList(sortParams) : null), record -> writer.writeNext(this.parseRecordParams(record)));
                }
            }
        }
        catch (IOException e) {
            log.error(e, "IO error while exporting records to CSV file.", new Object[0]);
        }
    }

    private String[] parseRecordParams(AccessRecordApi record) {
        String user = record.getUser();
        return new String[]{record.getTime(), user != null ? user : "<unknown>", record.getIpAddress(), this.i18nResolver.getText(record.getContentType()), record.getContentId(), this.i18nResolver.getText(record.getAction())};
    }
}

