/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.rest;

import com.enhancera.accesslog.common.access.ProgressTrackingGlobalAccessService;
import com.enhancera.accesslog.common.rest.ServiceResponse;
import com.enhancera.accesslog.common.servlet.GenericHttpRequest;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.UserUtils;

public class AccessBlockingTaskProgressResourceExecutor {
    private static final FormattingLogger log = FormattingLogger.getLogger(AccessBlockingTaskProgressResourceExecutor.class);
    private final ProgressTrackingGlobalAccessService accessService;
    private final UserUtils userUtils;

    public AccessBlockingTaskProgressResourceExecutor(ProgressTrackingGlobalAccessService accessService, UserUtils userUtils) {
        this.accessService = accessService;
        this.userUtils = userUtils;
    }

    public ServiceResponse get(GenericHttpRequest request) {
        if (!this.userUtils.isAdmin()) {
            log.error("User %s is not authorized access this resource.", this.userUtils.getRemoteUserKey());
            return ServiceResponse.serverError().status(403).build();
        }
        return ServiceResponse.ok(this.accessService.accessBlockingTaskProgress()).build();
    }
}

