/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.util;

import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.MacroInstance;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.sal.api.user.UserKey;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.CommonContentType;
import com.enhancera.accesslog.common.ContentType;
import com.enhancera.accesslog.common.recordparser.RecordParserUtils;
import com.enhancera.accesslog.common.util.FormattingUtils;
import com.enhancera.accesslog.common.util.UserUtils;
import com.enhancera.accesslog.confluence.ConfluenceContentType;
import com.enhancera.accesslog.confluence.listener.event.ConfluenceContentEntity;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class ConfluenceRecordsParserUtils {
    public static final String PARAM_ATTACHMENT_ID = "attachmentId";
    public static final String PARAM_COMMENT_ID = "commentId";
    public static final String URI_PARAM_CONTENT_ID = "contentId";
    public static final String URI_PARAM_CONTENT_TYPE = "contentType";
    public static final String PARAM_SPACE_KEY = "spaceKey";
    public static final String PARAM_POSTING_DAY = "postingDay";
    public static final String PARAM_STATUS = "status";
    public static final String PARAM_TITLE = "title";
    public static final String PARAM_PAGE_ID = "pageId";
    public static final String PARAM_START = "start";
    public static final String PARAM_LIMIT = "limit";
    public static final String PARAM_PARENT_VERSION = "parentVersion";
    public static final String PARAM_DEPTH = "depth";
    public static final String PARAM_VERSION = "version";
    public static final String PARAM_SLIDE = "slide";
    public static final String PARAM_ATTACHMENT = "attachment";
    public static final String PARAM_ATTACHMENT_VERSION = "attachmentVer";
    public static final String CONTENT_ID_DELIMITER = "|";
    public static final String HEADER_REFERER = "referer";
    public static final String REQUEST_PARAMETER_READY = "ready";
    public static final String REGEXP_REFERED_FROM_PREVIEW = ".*/pages/worddav/preview.action.*";
    public static final int DEFAULT_LIMIT = 25;
    private static final String STATUS_ANY = "any";
    private final AttachmentManager attachmentManager;

    public ConfluenceRecordsParserUtils(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public static ImmutableList<AccessRecord> parseContentAccessRecords(UserKey userKey, String ipAddress, @Nullable ContentEntityObject contentEntityObject, Action action) {
        if (contentEntityObject == null) {
            return ImmutableList.of();
        }
        return ConfluenceRecordsParserUtils.parseContentAccessRecords(userKey, ipAddress, new ConfluenceContentEntity(contentEntityObject), action);
    }

    public static ImmutableList<AccessRecord> parseContentAccessRecords(UserKey userKey, String ipAddress, ConfluenceContentEntity contentEntityObject, Action action) {
        ImmutableList<AccessRecord> result = ImmutableList.of();
        if (contentEntityObject.getContentType() == null) {
            return result;
        }
        ContentType contentType = contentEntityObject.getContentType();
        if (CommonContentType.COMMENT.equals(contentType)) {
            result = ConfluenceRecordsParserUtils.parseCommentAccessRecords(userKey, ipAddress, contentEntityObject, action);
        } else if (ConfluenceContentType.ACCESS_LOG_ABSTRACT_PAGE_CONTENT_TYPES.contains(contentType)) {
            result = ConfluenceRecordsParserUtils.parseAbstractPageAccessRecords(userKey, ipAddress, contentEntityObject, action);
        } else if (CommonContentType.ATTACHMENT.equals(contentType)) {
            result = ConfluenceRecordsParserUtils.parseAttachmentAccessRecords(userKey, ipAddress, contentEntityObject, action);
        }
        return result;
    }

    public static ImmutableList<AccessRecord> parseAttachmentTrashedOrRestroredOrDeletedAccessRecords(UserKey userKey, String ipAddress, ConfluenceContentEntity contentEntityObject, Action action) {
        return contentEntityObject != null ? ConfluenceRecordsParserUtils.parseAccessRecords(userKey, ipAddress, (ContentType)CommonContentType.ATTACHMENT, ConfluenceRecordsParserUtils.parseAttachmentContentId(contentEntityObject, false), contentEntityObject.getTitle(), action) : ImmutableList.of();
    }

    public static ImmutableList<AccessRecord> parseViewPagesAccessRecords(UserKey userKey, String ipAddress, List<? extends AbstractPage> abstractPages) {
        return abstractPages.stream().flatMap(page -> ConfluenceRecordsParserUtils.parseAbstractPageAccessRecords(userKey, ipAddress, new ConfluenceContentEntity((ContentEntityObject)page), Action.VIEW).stream()).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    public static ImmutableList<AccessRecord> parseAbstractPageAccessRecords(UserKey userKey, String ipAddress, ConfluenceContentEntity page, Action action) {
        ImmutableList<AccessRecord> result = ImmutableList.of();
        if (page != null) {
            String contentDisplayName = ConfluenceRecordsParserUtils.getAbstractPageContentDisplayName(page);
            result = ConfluenceRecordsParserUtils.parseAccessRecords(userKey, ipAddress, page.getContentType(), page.getId(), contentDisplayName, action);
        }
        return result;
    }

    private static ImmutableList<AccessRecord> parseAttachmentAccessRecords(UserKey userKey, String ipAddress, ConfluenceContentEntity attachment, Action action) {
        return ConfluenceRecordsParserUtils.parseAccessRecords(userKey, ipAddress, (ContentType)CommonContentType.ATTACHMENT, ConfluenceRecordsParserUtils.parseAttachmentContentId(attachment), attachment.getTitle(), action);
    }

    private static ImmutableList<AccessRecord> parseCommentAccessRecords(UserKey userKey, String ipAddress, ConfluenceContentEntity comment, Action action) {
        ImmutableList<AccessRecord> result = ImmutableList.of();
        if (comment != null) {
            result = ConfluenceRecordsParserUtils.parseAccessRecords(userKey, ipAddress, (ContentType)CommonContentType.COMMENT, comment.getId(), ConfluenceRecordsParserUtils.createCommentDisplayName(comment), action);
        }
        return result;
    }

    public ImmutableList<AccessRecord> parseViewAttachmentRecords(UserKey userKey, String ipAddress, @Nullable AbstractPage page, @Nullable String attachmentFilename, int version) {
        return this.parseAttachmentRecords(userKey, ipAddress, page, attachmentFilename, version, Action.VIEW);
    }

    public ImmutableList<AccessRecord> parseAttachmentRecords(UserKey userKey, String ipAddress, @Nullable AbstractPage page, @Nullable String attachmentFilename, int version, Action action) {
        ImmutableList<AccessRecord> result = ImmutableList.of();
        Attachment attachment = this.attachmentManager.getAttachment((ContentEntityObject)page, attachmentFilename, version);
        if (attachment != null) {
            result = ConfluenceRecordsParserUtils.parseAccessRecords(userKey, ipAddress, (ContentType)CommonContentType.ATTACHMENT, ConfluenceRecordsParserUtils.parseAttachmentContentId(new ConfluenceContentEntity((ContentEntityObject)attachment)), attachment.getTitle(), action);
        }
        return result;
    }

    public ImmutableList<AccessRecord> parseDownloadAttachmentSlideRecords(UserKey userKey, String ipAddress, @Nullable AbstractPage page, @Nullable String attachmentFilename, int version, int slide) {
        ImmutableList<AccessRecord> result = ImmutableList.of();
        Attachment attachment = this.attachmentManager.getAttachment((ContentEntityObject)page, attachmentFilename, version);
        if (attachment != null) {
            result = ConfluenceRecordsParserUtils.parseAccessRecords(userKey, ipAddress, (ContentType)CommonContentType.ATTACHMENT, String.join((CharSequence)CONTENT_ID_DELIMITER, ConfluenceRecordsParserUtils.parseAttachmentContentId(new ConfluenceContentEntity((ContentEntityObject)attachment)), String.valueOf(slide)), attachment.getTitle(), Action.DOWNLOAD);
        }
        return result;
    }

    public static String parseAttachmentContentId(ConfluenceContentEntity attachment) {
        return ConfluenceRecordsParserUtils.parseAttachmentContentId(attachment, true);
    }

    private static String parseAttachmentContentId(ConfluenceContentEntity attachment, boolean isAttachmentVersionNeeded) {
        String attachmentVersion = isAttachmentVersionNeeded ? String.valueOf(attachment.getVersion()) : "";
        return String.join((CharSequence)CONTENT_ID_DELIMITER, attachment.getContainerIdAsString(), attachment.getLatestVersionIdAsString(), attachmentVersion);
    }

    public static ImmutableList<AccessRecord> parseViewMacroRecords(UserKey userKey, String ipAddress, @Nullable ContentEntityObject contentEntityObject, String macroId, MacroInstance macro) {
        return contentEntityObject != null ? ConfluenceRecordsParserUtils.parseAccessRecords(userKey, ipAddress, (ContentType)ConfluenceContentType.MACRO, String.join((CharSequence)CONTENT_ID_DELIMITER, String.valueOf(contentEntityObject.getId()), macroId), macro.getName(), Action.VIEW) : ImmutableList.of();
    }

    public static ImmutableList<AccessRecord> parseAccessRecords(UserKey userKey, String ipAddress, ContentType contentType, Long contentId, String contentDisplayName, Action action) {
        return ConfluenceRecordsParserUtils.parseAccessRecords(userKey, ipAddress, contentType, String.valueOf(contentId), contentDisplayName, action);
    }

    public static ImmutableList<AccessRecord> parseAccessRecords(long timestamp, UserKey userKey, String ipAddress, ContentType contentType, String contentId, String contentDisplayName, Action action) {
        return ImmutableList.of(AccessRecord.create(new DateTime(timestamp), UserUtils.getUserKeyStr(userKey), ipAddress, contentType, contentId, contentDisplayName, action));
    }

    public static ImmutableList<AccessRecord> parseAccessRecords(UserKey userKey, String ipAddress, ContentType contentType, String contentId, String contentDisplayName, Action action) {
        return ImmutableList.of(AccessRecord.create(DateTime.now(), UserUtils.getUserKeyStr(userKey), ipAddress, contentType, contentId, contentDisplayName, action));
    }

    public static ImmutableSet<ContentStatus> parseContentStatusesContentById(List<String> statuses, int version) {
        ArrayList<String> result = new ArrayList<String>(statuses);
        if (version != 0) {
            result.add(ContentStatus.HISTORICAL.getValue());
            result.add(ContentStatus.CURRENT.getValue());
        }
        return ConfluenceRecordsParserUtils.parseContentStatuses(result);
    }

    public static ImmutableSet<ContentStatus> parseContentStatuses(List<String> statuses) {
        ArrayList<String> result = new ArrayList<String>(statuses);
        if (statuses.contains(STATUS_ANY)) {
            if (result.size() == 1) {
                result.add(ContentStatus.CURRENT.getValue());
                result.add(ContentStatus.TRASHED.getValue());
                result.add(ContentStatus.DRAFT.getValue());
            }
            result.remove(STATUS_ANY);
        } else if (statuses.isEmpty()) {
            result.add(ContentStatus.CURRENT.getValue());
        }
        return result.stream().map(ContentStatus::valueOf).collect(Collectors.collectingAndThen(Collectors.toSet(), ImmutableSet::copyOf));
    }

    @VisibleForTesting
    public static String getAbstractPageContentDisplayName(@Nullable ConfluenceContentEntity contentEntityObject) {
        if (contentEntityObject == null) {
            return "unknown";
        }
        String contentDisplayName = contentEntityObject.getTitle();
        if (contentDisplayName == null) {
            contentDisplayName = RecordParserUtils.createContentDisplayNameWithAuxiliaryParam(contentEntityObject.getSpaceKey(), FormattingUtils.formatTime(new DateTime(contentEntityObject.getCreationDate())));
        }
        return contentDisplayName;
    }

    private static String createCommentDisplayName(ConfluenceContentEntity comment) {
        return RecordParserUtils.createCommentDisplayName(ConfluenceRecordsParserUtils.getAbstractPageContentDisplayName(comment), new DateTime(comment.getCreationDate()));
    }
}

