/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.jakarta.responseparsers;

import com.enhancera.accesslog.jakarta.responseparsers.ContentCapturingOutputStream;
import com.enhancera.accesslog.jakarta.responseparsers.ContentCapturingPrintWriter;
import com.enhancera.accesslog.jakarta.responseparsers.ContentCapturingServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ContentCachingResponseWrapper
extends ContentCapturingServletResponse {
    public ContentCachingResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    @Override
    public ContentCapturingOutputStream createStream() {
        return new ContentCapturingOutputStream(this.getResponse().getCharacterEncoding());
    }

    @Override
    public ContentCapturingPrintWriter createWriter() {
        return new ContentCapturingPrintWriter(new PrintWriter(new StringWriter()));
    }

    @Override
    public String getContent() {
        String content = super.getContent();
        try {
            this.copyBodyToResponse(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return content;
    }

    private void copyBodyToResponse(String content) throws IOException {
        this.getResponse().getWriter().write(content);
    }
}

