/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.jakarta;

import com.atlassian.sal.api.user.UserKey;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.rest.HttpMethod;
import com.enhancera.accesslog.jakarta.util.JakartaRequestUtils;
import com.google.common.collect.ImmutableListMultimap;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class JakartaRequestDataFactory {
    private JakartaRequestDataFactory() {
    }

    public static RequestData create(HttpServletRequest httpRequest, UserKey userKey, @Nullable String body) {
        String ipAddress = JakartaRequestUtils.extractIpAddress(httpRequest).orElse(null);
        DateTime time = DateTime.now();
        HttpMethod method = HttpMethod.fromString(httpRequest.getMethod());
        String uri = httpRequest.getRequestURI();
        String contextPath = httpRequest.getContextPath();
        String pathInfo = httpRequest.getPathInfo();
        ImmutableListMultimap<String, String> requestParameters = JakartaRequestUtils.createRequestParametersMultimap(httpRequest);
        ImmutableListMultimap<String, String> requestHeaders = JakartaRequestUtils.createRequestHeadersMultimap(httpRequest);
        return RequestData.create(userKey, ipAddress, time, method, uri, contextPath, Optional.ofNullable(pathInfo), Optional.ofNullable(body), requestParameters, requestHeaders);
    }
}

