/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.util;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.ContentType;
import com.enhancera.accesslog.common.ao.AccessRecordEntity;
import com.enhancera.accesslog.common.rest.AccessRecordApi;
import com.enhancera.accesslog.common.util.ActionAndContentTypeToUiNameUtils;
import com.enhancera.accesslog.common.util.ContentTypeService;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.FormattingUtils;
import java.util.Optional;
import org.joda.time.DateTime;

public class RecordApiFactory {
    private static final FormattingLogger log = FormattingLogger.getLogger(RecordApiFactory.class);
    private final ContentTypeService contentTypeService;
    private final ActionAndContentTypeToUiNameUtils actionAndContentTypeToUiNameUtils;
    private final UserManager userManager;

    public RecordApiFactory(ContentTypeService contentTypeService, ActionAndContentTypeToUiNameUtils actionAndContentTypeToUiNameUtils, UserManager userManager) {
        this.contentTypeService = contentTypeService;
        this.actionAndContentTypeToUiNameUtils = actionAndContentTypeToUiNameUtils;
        this.userManager = userManager;
    }

    public Optional<AccessRecordApi> getRecordApi(AccessRecordEntity entity) {
        Optional<ContentType> contentType = this.contentTypeService.createContentType(entity.getContentType());
        if (!contentType.isPresent()) {
            return Optional.empty();
        }
        String contentDisplayName = entity.getNewContentDisplayName();
        String userKeyStr = entity.getUser();
        UserKey userKey = userKeyStr != null ? new UserKey(userKeyStr) : null;
        UserProfile userProfile = userKey != null ? this.userManager.getUserProfile(userKey) : null;
        String username = userProfile != null ? userProfile.getUsername() : userKeyStr;
        String ipAddress = entity.getIpAddress();
        if ("-".equals(ipAddress)) {
            ipAddress = null;
        }
        String urlPath = entity.getUrlPath();
        AccessRecordApi api = AccessRecordApi.create(FormattingUtils.formatTime(new DateTime(entity.getTime())), username, ipAddress, this.actionAndContentTypeToUiNameUtils.getContentTypeUiText(contentType.get()), contentDisplayName, urlPath != null ? urlPath : this.contentTypeService.createContentIdViewUri(contentType.get(), entity.getContentId(), entity.getNewContentDisplayName()), this.actionAndContentTypeToUiNameUtils.getActionUiText(Action.valueOf(entity.getAction())));
        log.debug(api.toString(), new Object[0]);
        return Optional.of(api);
    }
}

