/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.javax.util;

import com.enhancera.accesslog.common.recordparser.RecordParserUtils;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.javax.StatusExposingServletResponse;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import java.util.Optional;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public final class JavaxRecordParserUtils {
    public static ImmutableListMultimap<String, String> createResponseHeadersForEventsFilterResponse(HttpServletRequest httpServletRequest, StatusExposingServletResponse statusExposingServletResponse) {
        ImmutableListMultimap<String, String> responseHeaders = statusExposingServletResponse.getAllHeaders();
        Optional<String> userNameHeaderValueForDoAuthenticateAction = JavaxRecordParserUtils.getUserNameHeaderValueForDoAuthenticateActionRecordParserInConfluence(httpServletRequest, statusExposingServletResponse);
        if (userNameHeaderValueForDoAuthenticateAction.isPresent()) {
            ArrayListMultimap<String, String> headersTemp = ArrayListMultimap.create(responseHeaders);
            headersTemp.put("X-AUSERNAME", userNameHeaderValueForDoAuthenticateAction.get());
            responseHeaders = ImmutableListMultimap.copyOf(headersTemp);
        }
        return responseHeaders;
    }

    private static Optional<String> getUserNameHeaderValueForDoAuthenticateActionRecordParserInConfluence(HttpServletRequest httpRequest, HttpServletResponseWrapper response) {
        if (!JavaxRecordParserUtils.isRequestRelatedToUrlsForWhatXausernameHeaderNeededInParser(httpRequest)) {
            return Optional.empty();
        }
        ServletResponse innerServletResponseTemp = response.getResponse();
        do {
            if (!(innerServletResponseTemp instanceof HttpServletResponse)) continue;
            HttpServletResponse httpServletResponseTemp = (HttpServletResponse)innerServletResponseTemp;
            if (httpServletResponseTemp.getHeaderNames().contains("X-AUSERNAME")) {
                return Optional.ofNullable(httpServletResponseTemp.getHeader("X-AUSERNAME"));
            }
            if (httpServletResponseTemp instanceof HttpServletResponseWrapper) {
                HttpServletResponseWrapper httpServletResponseWrapperTemp = (HttpServletResponseWrapper)httpServletResponseTemp;
                innerServletResponseTemp = httpServletResponseWrapperTemp.getResponse();
                continue;
            }
            innerServletResponseTemp = null;
        } while (innerServletResponseTemp != null);
        return Optional.empty();
    }

    private static boolean isRequestRelatedToUrlsForWhatXausernameHeaderNeededInParser(HttpServletRequest httpRequest) {
        return RecordParserUtils.CONFLUENCE_XAUSERNAME_HEADER_NEEDED_IN_PARSER_URLS.stream().anyMatch(regexp -> RequestUtils.decode(httpRequest.getRequestURI()).matches(Strings.nullToEmpty(httpRequest.getContextPath()).concat((String)regexp)));
    }

    private JavaxRecordParserUtils() {
    }
}

