/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.javax;

import com.atlassian.sal.api.web.context.HttpContext;
import com.enhancera.accesslog.common.servlet.GenericHttpRequest;
import com.enhancera.accesslog.common.servlet.IpResolver;
import com.enhancera.accesslog.javax.JavaxHttpRequestAdapter;
import com.enhancera.accesslog.javax.util.JavaxRequestUtils;
import javax.servlet.http.HttpServletRequest;

public class JavaxIpResolver
implements IpResolver {
    public static final String DEFAULT_IP_VALUE = "-";
    private final HttpContext httpContext;

    public JavaxIpResolver(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    @Override
    public GenericHttpRequest getCurrentRequest() {
        return new JavaxHttpRequestAdapter(this.httpContext.getRequest());
    }

    @Override
    public String getCurrentIp() {
        HttpServletRequest request = this.httpContext.getRequest();
        return JavaxRequestUtils.extractIpAddress(request).orElse(null);
    }

    @Override
    public String extractIpAddress(GenericHttpRequest request) {
        if (!(request instanceof JavaxHttpRequestAdapter)) {
            return DEFAULT_IP_VALUE;
        }
        JavaxHttpRequestAdapter javaxHttpRequest = (JavaxHttpRequestAdapter)request;
        return JavaxRequestUtils.extractIpAddress(javaxHttpRequest.getDelegate()).orElse(DEFAULT_IP_VALUE);
    }
}

