/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.javax;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.enhancera.accesslog.common.AdditionalFilter;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.logwriters.AccessLogWriter;
import com.enhancera.accesslog.common.recordparser.RecordsParser;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.LicenseCheckResult;
import com.enhancera.accesslog.common.util.LicenseChecker;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.javax.JavaxHttpRequestAdapter;
import com.enhancera.accesslog.javax.JavaxRequestDataFactory;
import com.enhancera.accesslog.javax.MultiReadHttpServletRequest;
import com.enhancera.accesslog.javax.StatusExposingServletResponse;
import com.enhancera.accesslog.javax.responseparsers.ContentCachingResponseWrapper;
import com.enhancera.accesslog.javax.util.JavaxRecordParserUtils;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Qualifier;

@UnrestrictedAccess
public class EventsFilter
implements Filter {
    private long lastReportedTime = 0L;
    private static final FormattingLogger log = FormattingLogger.getLogger(EventsFilter.class);
    public static final String REGEXP_KNOWLEDGEBASE_ARTICLES_REMOTEPAGEVIEW_URI = "/rest/servicedesk/knowledgebase/latest/articles/remotepageview.*";
    private static final int MIN_THREADS_NUMBER = 10;
    private static final int MAX_THREADS_NUMBER = 50;
    private static final int ADDITIONAL_THREADS_KEEP_ALIVE_TIME = 10;
    public static final ImmutableMap<String, String> PREPROCESS_EVENTS = ImmutableMap.of("/rest/(insight|assets|insight-am)/[^/]+/attachments/(?<id>\\d+)/?", "DELETE");
    private FilterConfig config;
    private final UserManager userManager;
    private final RecordsParser recordsParser;
    private final AccessLogWriter accessLogWriter;
    private final AdditionalFilter additionalFilter;
    private final LicenseChecker licenseChecker;
    private ThreadPoolExecutor threadPoolExecutor;

    public EventsFilter(UserManager userManager, @Qualifier(value="recordsParser") RecordsParser recordsParser, AccessLogWriter accessLogWriter, AdditionalFilter additionalFilter, PluginLicenseManager pluginLicenseManager, LicenseChecker licenseChecker) {
        this.userManager = userManager;
        this.recordsParser = recordsParser;
        this.accessLogWriter = accessLogWriter;
        this.additionalFilter = additionalFilter;
        this.licenseChecker = licenseChecker;
    }

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
        this.threadPoolExecutor = new ThreadPoolExecutor(10, 50, 10L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
        Thread.setDefaultUncaughtExceptionHandler((t2, e) -> log.error(e));
    }

    public void destroy() {
        this.config = null;
        this.threadPoolExecutor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            log.info("Either request or response are non-HTTP. Don't know how to deal with them, so just skipping.", new Object[0]);
            return;
        }
        Object httpRequest = (HttpServletRequest)request;
        Object httpResponse = (HttpServletResponse)response;
        JavaxHttpRequestAdapter javaxHttpRequestAdapter = new JavaxHttpRequestAdapter((HttpServletRequest)httpRequest);
        boolean isRequestSuitable = false;
        boolean isLicenseCheckResultOk = false;
        boolean isResponseBodyRequired = false;
        String requestBody = null;
        try {
            if (this.additionalFilter.isRequestBodyRequired(javaxHttpRequestAdapter)) {
                MultiReadHttpServletRequest multiReadHttpServletRequest = new MultiReadHttpServletRequest((HttpServletRequest)httpRequest);
                requestBody = multiReadHttpServletRequest.getBody();
                httpRequest = multiReadHttpServletRequest;
            }
            if (!(isRequestSuitable = this.additionalFilter.isRequestSuitable(javaxHttpRequestAdapter))) {
                log.debug("Request has been intercepted but should not be processed.", new Object[0]);
                return;
            }
            LicenseCheckResult licenseCheckResult = this.licenseChecker.checkLicense();
            isLicenseCheckResultOk = licenseCheckResult.isOk();
            if (isLicenseCheckResultOk) {
                isResponseBodyRequired = this.additionalFilter.isResponseBodyRequired(javaxHttpRequestAdapter);
                httpResponse = isResponseBodyRequired ? new ContentCachingResponseWrapper((HttpServletResponse)httpResponse) : new StatusExposingServletResponse((HttpServletResponse)httpResponse);
            } else if (System.currentTimeMillis() - this.lastReportedTime > 300000L) {
                log.warn("Access logging disabled due to the following reason: %s", licenseCheckResult.getMessage());
                this.lastReportedTime = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            log.error(e, "An exception occurred when processing event.", new Object[0]);
            isRequestSuitable = false;
        }
        finally {
            boolean alreadyProcessed = false;
            if (isLicenseCheckResultOk && isRequestSuitable && this.isRequestShouldBePreprocessed((HttpServletRequest)httpRequest)) {
                alreadyProcessed = true;
                this.parseRecords(isResponseBodyRequired, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse, requestBody, true);
            }
            try {
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
            finally {
                if (isLicenseCheckResultOk && isRequestSuitable && !alreadyProcessed) {
                    this.parseRecords(isResponseBodyRequired, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse, requestBody, false);
                }
            }
        }
    }

    private boolean isRequestShouldBePreprocessed(HttpServletRequest request) {
        for (Map.Entry entry : PREPROCESS_EVENTS.entrySet()) {
            if (!RequestUtils.decode(request.getRequestURI()).matches(request.getContextPath().concat((String)entry.getKey())) || !((String)entry.getValue()).equals(request.getMethod())) continue;
            return true;
        }
        return false;
    }

    private boolean isConfluenceBaseArticleView(RequestData requestData) {
        return RequestUtils.decode(requestData.getUri()).matches(requestData.getContextPath().concat(REGEXP_KNOWLEDGEBASE_ARTICLES_REMOTEPAGEVIEW_URI));
    }

    private void parseRecords(boolean isResponseBodyRequired, HttpServletRequest httpRequest, HttpServletResponse httpResponse, @Nullable String requestBody, boolean isPreprocess) {
        try {
            UserKey userKey = this.userManager.getRemoteUserKey();
            if (this.additionalFilter.isRequestSuitable(new JavaxHttpRequestAdapter(httpRequest))) {
                int responseStatus;
                RequestData requestData = JavaxRequestDataFactory.create(httpRequest, userKey, requestBody);
                String responseBody = null;
                ImmutableListMultimap<String, String> responseHeaders = ImmutableListMultimap.of();
                if (isResponseBodyRequired) {
                    ContentCachingResponseWrapper responseWrapper = (ContentCachingResponseWrapper)httpResponse;
                    responseBody = EventsFilter.getContent(responseWrapper).orElse(null);
                    responseStatus = responseWrapper.getStatus();
                } else {
                    StatusExposingServletResponse statusExposingServletResponse = (StatusExposingServletResponse)httpResponse;
                    responseStatus = statusExposingServletResponse.getStatusCode();
                    responseHeaders = JavaxRecordParserUtils.createResponseHeadersForEventsFilterResponse(httpRequest, statusExposingServletResponse);
                }
                ResponseData responseData = ResponseData.create(responseStatus, responseBody, responseHeaders);
                if (isPreprocess || this.isConfluenceBaseArticleView(requestData)) {
                    this.accessLogWriter.write(this.recordsParser.parseRecords(requestData, responseData));
                } else {
                    this.threadPoolExecutor.execute(() -> this.accessLogWriter.write(this.recordsParser.parseRecords(requestData, responseData)));
                }
            }
        }
        catch (Exception e) {
            log.error(e, "An exception occurred when parsing records.", new Object[0]);
        }
    }

    private static Optional<String> getContent(ContentCachingResponseWrapper responseWrapper) {
        return Optional.ofNullable(responseWrapper.getContent());
    }
}

