/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.util;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.UserUtils;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

public class ConfluenceUserPermissionsUtils {
    private static final FormattingLogger log = FormattingLogger.getLogger(ConfluenceUserPermissionsUtils.class);
    private final PermissionManager permissionManager;
    private final UserAccessor userAccessor;
    private final UserUtils userUtils;

    public ConfluenceUserPermissionsUtils(PermissionManager permissionManager, UserAccessor userAccessor, UserUtils userUtils) {
        this.permissionManager = permissionManager;
        this.userAccessor = userAccessor;
        this.userUtils = userUtils;
    }

    public boolean isUserHasViewPermissions(@Nullable UserKey userKey, ConfluenceEntityObject contentEntityObject) {
        ConfluenceUser userObj = this.userAccessor.getUserByKey(userKey);
        boolean isPermitted = this.invokeHasPermission(userObj, Permission.VIEW, contentEntityObject);
        if (!isPermitted) {
            log.debug("User %s is not allowed to see content with id %d.", this.userUtils.getUserName(userKey), contentEntityObject.getId());
        }
        return isPermitted;
    }

    private boolean invokeHasPermission(Object userObj, Permission permission, Object target) {
        try {
            Method m4 = this.permissionManager.getClass().getMethod("hasPermission", Class.forName("com.atlassian.confluence.user.ConfluenceUser"), Permission.class, Object.class);
            return (Boolean)m4.invoke((Object)this.permissionManager, userObj, permission, target);
        }
        catch (NoSuchMethodException e1) {
            try {
                Method m5 = this.permissionManager.getClass().getMethod("hasPermission", Class.forName("com.atlassian.user.User"), Permission.class, Object.class);
                return (Boolean)m5.invoke((Object)this.permissionManager, userObj, permission, target);
            }
            catch (Exception e2) {
                log.error("Error calling old hasPermission(User, ...) via reflection", e2);
            }
        }
        catch (Exception e) {
            log.error("Error invoking hasPermission reflectively", e);
        }
        return false;
    }
}

