/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser.rest;

import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.content.ContentType;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.recordparser.RecordParserUtils;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.confluence.recordparser.rest.BulkRestUriMatchingParser;
import com.enhancera.accesslog.confluence.util.ConfluenceApiContentRecordsParserUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceContentUtils;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.apache.commons.lang3.math.NumberUtils;

public class ContentOfSpaceRestViewRecordParser
extends BulkRestUriMatchingParser {
    private static final String DEPTH_ROOT_STR = "ROOT";
    private final ConfluenceContentUtils contentUtils;
    private final ConfluenceApiContentRecordsParserUtils confluenceApiContentRecordsParserUtils;

    public ContentOfSpaceRestViewRecordParser(ConfluenceApiContentRecordsParserUtils confluenceApiContentRecordsParserUtils, ConfluenceContentUtils contentUtils) {
        super("/rest/api/space/(?<spaceKey>[A-Za-z0-9]+)/content(/(?<contentType>[a-z]+))?/?");
        this.confluenceApiContentRecordsParserUtils = confluenceApiContentRecordsParserUtils;
        this.contentUtils = contentUtils;
    }

    @Override
    protected ImmutableList<AccessRecord> parse(RequestData requestData, ResponseData responseData) {
        ConfluenceApiContentRecordsParserUtils.addUserToThreadLocal(requestData.getUserKey());
        return this.parseRestGetContentRecords(requestData);
    }

    ImmutableList<AccessRecord> parseRestGetContentRecords(RequestData requestData) {
        String spaceKey = RecordParserUtils.parseOptionalValue("spaceKey", RequestUtils.parseUriParam(requestData.getContextPath().concat("/rest/api/space/(?<spaceKey>[A-Za-z0-9]+)/content(/(?<contentType>[a-z]+))?/?"), requestData.getUri(), "spaceKey"));
        String depthStr = requestData.getRequestParameterValue("depth").orElse(null);
        String start = requestData.getRequestParameterValue("start").orElse(null);
        String limit = requestData.getRequestParameterValue("limit").orElse(null);
        Depth depth = ContentOfSpaceRestViewRecordParser.createDepth(depthStr).orElse(null);
        ContentType contentType = ContentOfSpaceRestViewRecordParser.getContentType(requestData).orElse(null);
        return this.confluenceApiContentRecordsParserUtils.parseAbstractPagesAccessRecords(this.contentUtils.getContentOfSpace(spaceKey, depth, contentType, NumberUtils.toInt(start), NumberUtils.toInt(limit, 25)), requestData);
    }

    private static Optional<ContentType> getContentType(RequestData requestData) {
        String contentTypeStr = RecordParserUtils.parseOptionalValue("contentType", RequestUtils.parseUriParam(requestData.getContextPath().concat("/rest/api/space/(?<spaceKey>[A-Za-z0-9]+)/content(/(?<contentType>[a-z]+))?/?"), requestData.getUri(), "contentType"));
        Optional<ContentType> contentType = Optional.empty();
        if (!Strings.isNullOrEmpty(contentTypeStr)) {
            contentType = Optional.of(ContentType.valueOf((String)contentTypeStr));
        }
        return contentType;
    }

    private static Optional<Depth> createDepth(String depthStr) {
        Depth depth = null;
        if (depthStr == null || Depth.ALL.toString().equals(depthStr)) {
            depth = Depth.ALL;
        }
        if (DEPTH_ROOT_STR.equals(depthStr != null ? depthStr.toUpperCase() : null)) {
            depth = Depth.ROOT;
        }
        return Optional.ofNullable(depth);
    }
}

