/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser.login;

import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.recordparser.UriMatchingParserWithSpecifiedMethods;
import com.enhancera.accesslog.common.rest.HttpMethod;
import com.enhancera.accesslog.confluence.util.ConfluenceWebRecordsParserUtils;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;

public class DropAdminAccessRecordsParser
extends UriMatchingParserWithSpecifiedMethods {
    private static final String X_ATLASSIAN_WEBSUDO_RESPONSE_HEADER_NAME = "X-Atlassian-WebSudo";
    private static final String X_ATLASSIAN_WEBSUDO_RESPONSE_HEADER_VALUE = "Require-Authentication";
    private ConfluenceWebRecordsParserUtils confluenceWebRecordsParserUtils;

    public DropAdminAccessRecordsParser(ConfluenceWebRecordsParserUtils confluenceWebRecordsParserUtils) {
        super("/(ajax/)?dropauthentication.action", ImmutableSet.of(HttpMethod.GET));
        this.confluenceWebRecordsParserUtils = confluenceWebRecordsParserUtils;
    }

    @Override
    protected ImmutableList<AccessRecord> parse(RequestData requestData, ResponseData responseData) {
        ImmutableCollection webSudoHeaderValues = responseData.getHeaders().get((Object)X_ATLASSIAN_WEBSUDO_RESPONSE_HEADER_NAME);
        if (!((ImmutableList)webSudoHeaderValues).contains(X_ATLASSIAN_WEBSUDO_RESPONSE_HEADER_VALUE)) {
            return ImmutableList.of();
        }
        String userName = "<unknown>";
        ImmutableCollection userNames = responseData.getHeaders().get((Object)"X-AUSERNAME");
        if (!userNames.isEmpty()) {
            userName = (String)((ImmutableList)userNames).iterator().next();
        }
        ImmutableList<AccessRecord> accessRecords = this.confluenceWebRecordsParserUtils.parseLoginAccessRecordsFoDoAuthenticateAction(requestData.getIpAddress(), userName, Action.ADMIN_ACCESS_REMOVED_FOR_USER);
        return accessRecords;
    }
}

