/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.recordparser.RecordParserUtils;
import com.enhancera.accesslog.common.recordparser.UriMatchingNonHeadParser;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceContentUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceRecordsParserUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceUriRegexp;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.apache.commons.lang3.math.NumberUtils;

public class DocumentConversionRecordParser
extends UriMatchingNonHeadParser {
    private final ConfluenceRecordsParserUtils recordsParserUtils;
    private final ConfluenceContentUtils contentUtils;

    public DocumentConversionRecordParser(ConfluenceRecordsParserUtils recordsParserUtils, ConfluenceContentUtils contentUtils) {
        super(ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_DOCUMENT_CONVERSION_URI);
        this.recordsParserUtils = recordsParserUtils;
        this.contentUtils = contentUtils;
    }

    @Override
    protected ImmutableList<AccessRecord> parse(RequestData requestData, ResponseData responseData) {
        ImmutableList<AccessRecord> result = ImmutableList.of();
        long attachmentId = RecordParserUtils.parseOptionalValue("id", RequestUtils.parseUriParamLong(requestData.getContextPath().concat(ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_DOCUMENT_CONVERSION_URI), requestData.getUri(), "id"));
        int version = NumberUtils.toInt(RecordParserUtils.parseOptionalValue("version", RequestUtils.parseUriParam(requestData.getContextPath().concat(ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_DOCUMENT_CONVERSION_URI), requestData.getUri(), "version")));
        Optional<Attachment> attachmentOptional = this.contentUtils.getAttachment(attachmentId);
        if (attachmentOptional.isPresent()) {
            Attachment attachment = attachmentOptional.get();
            result = this.recordsParserUtils.parseViewAttachmentRecords(requestData.getUserKey(), requestData.getIpAddress(), (AbstractPage)attachment.getContainer(), attachment.getFileName(), version);
        }
        return result;
    }
}

