/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.util;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.enhancera.accesslog.common.servlet.GenericHttpRequest;
import com.enhancera.accesslog.common.servlet.GenericHttpResponse;
import com.enhancera.accesslog.common.servlet.HttpStatus;
import com.enhancera.accesslog.common.util.UserUtils;
import java.io.IOException;
import java.net.URI;

public class UserRedirect {
    private final LoginUriProvider loginUriProvider;
    private final UserUtils userUtils;

    public UserRedirect(LoginUriProvider loginUriProvider, UserUtils userUtils) {
        this.loginUriProvider = loginUriProvider;
        this.userUtils = userUtils;
    }

    public void redirectToLogin(GenericHttpRequest request, GenericHttpResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    public boolean redirectIfNotAllowed(GenericHttpRequest request, GenericHttpResponse response) throws IOException {
        if (this.userUtils.getRemoteUserProfile() == null) {
            this.redirectToLogin(request, response);
            return true;
        }
        if (!this.userUtils.isAdmin()) {
            response.sendError(HttpStatus.FORBIDDEN.code());
            return true;
        }
        return false;
    }

    private URI getUri(GenericHttpRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

