/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.util;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.enhancera.accesslog.common.util.LicenseCheckResult;
import com.google.common.collect.ImmutableList;

public class LicenseChecker {
    public static final long LICENSE_CHECK_REPORT_INTERVAL_MILLIS = 300000L;
    private static final String LICENSE_PROPERTY_PREFIX = "accesslog.license.";
    private static final String LINK_TEXT_PROPERTY_SUFFIX = "link.text";
    private final PluginLicenseManager pluginLicenseManager;
    private final I18nResolver i18nResolver;

    public LicenseChecker(PluginLicenseManager pluginLicenseManager, I18nResolver i18nResolver) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.i18nResolver = i18nResolver;
    }

    public LicenseCheckResult checkLicense() {
        Option license = this.pluginLicenseManager.getLicense();
        if (!license.isDefined()) {
            return LicenseCheckResult.create(false, this.createErrorMessage("no.license"));
        }
        if (!((PluginLicense)license.get()).isValid()) {
            String errorMessage = null;
            if (((PluginLicense)license.get()).getError().isDefined()) {
                switch ((LicenseError)((PluginLicense)license.get()).getError().get()) {
                    case EXPIRED: {
                        errorMessage = this.createErrorMessage("expired");
                        break;
                    }
                    case TYPE_MISMATCH: {
                        errorMessage = this.createErrorMessageWithAppName("type.mismatch");
                        break;
                    }
                    case USER_MISMATCH: {
                        errorMessage = this.createErrorMessageWithAppName("too.many.users");
                        break;
                    }
                    case VERSION_MISMATCH: {
                        errorMessage = this.createErrorMessage("support.expired.for.version");
                        break;
                    }
                }
            }
            if (errorMessage == null) {
                errorMessage = this.createErrorMessage("invalid");
            }
            return LicenseCheckResult.create(false, errorMessage);
        }
        return LicenseCheckResult.create(true);
    }

    private String createErrorMessage(String licensePropertySuffix) {
        return this.createErrorMessage(licensePropertySuffix, false);
    }

    private String createErrorMessageWithAppName(String licensePropertySuffix) {
        return this.createErrorMessage(licensePropertySuffix, true);
    }

    private String createErrorMessage(String licensePropertySuffix, boolean withAppName) {
        String licenseProperty = LICENSE_PROPERTY_PREFIX + licensePropertySuffix;
        return String.format(this.getPropertyText(licenseProperty), this.createParamForErrorMessage(licenseProperty, withAppName).toArray());
    }

    private ImmutableList<String> createParamForErrorMessage(String licenseProperty, boolean withAppName) {
        String pluginName = this.getPropertyText("accesslog.plugin.name");
        String appName = this.getPropertyText("app.name");
        String purchaseLink = this.getPropertyText("accesslog.purchase.link");
        ImmutableList.Builder params = ImmutableList.builder();
        params.add(pluginName);
        if (withAppName) {
            params.add(appName);
        }
        params.add(LicenseChecker.createHtmlLink(this.getPropertyText(licenseProperty + "." + LINK_TEXT_PROPERTY_SUFFIX), purchaseLink));
        return params.build();
    }

    private String getPropertyText(String propertyName) {
        return this.i18nResolver.getText(propertyName);
    }

    private static String createHtmlLink(String linkText, String linkUrl) {
        return String.format("<a href='%s'>%s</a>", linkUrl, linkText);
    }
}

