/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.util;

import com.atlassian.sal.api.message.I18nResolver;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.ContentType;
import com.enhancera.accesslog.common.util.ContentTypeService;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ActionAndContentTypeToUiNameUtils {
    private ImmutableMap<Action, String> actionToUiName;
    private ImmutableMap<ContentType, String> contentTypeToUiName;
    private final I18nResolver i18nResolver;
    private final ContentTypeService contentTypeService;

    public ActionAndContentTypeToUiNameUtils(I18nResolver i18nResolver, ContentTypeService contentTypeService) {
        this.i18nResolver = i18nResolver;
        this.contentTypeService = contentTypeService;
    }

    public String getActionUiText(Action action) {
        if (this.actionToUiName == null) {
            this.initializeActionToUiNameMap();
        }
        return this.actionToUiName.get((Object)action);
    }

    private void initializeActionToUiNameMap() {
        HashMap<Action, String> actionToUiNameTemp = new HashMap<Action, String>();
        for (Action action : Action.values()) {
            actionToUiNameTemp.put(action, this.i18nResolver.getText(action.getDisplayNameProperty()));
        }
        this.actionToUiName = ImmutableMap.copyOf(actionToUiNameTemp);
    }

    public String getContentTypeUiText(ContentType contentType) {
        if (this.contentTypeToUiName == null) {
            this.initializeContentTypeToUiNameMap();
        }
        return this.contentTypeToUiName.get(contentType);
    }

    private void initializeContentTypeToUiNameMap() {
        HashMap<ContentType, String> contentTypeToUiNameTemp = new HashMap<ContentType, String>();
        for (ContentType confluenceContentType : this.contentTypeService.getContentTypes()) {
            contentTypeToUiNameTemp.put(confluenceContentType, this.i18nResolver.getText(confluenceContentType.getDisplayNameProperty()));
        }
        this.contentTypeToUiName = ImmutableMap.copyOf(contentTypeToUiNameTemp);
    }

    public ImmutableList<ContentType> getContentTypesByUiTextSubstringIgnoreCase(String contentTypeUiTextSubstring) {
        if (this.contentTypeToUiName == null) {
            this.initializeContentTypeToUiNameMap();
        }
        return this.contentTypeToUiName.entrySet().stream().filter(contentTypeToUiNameEntry -> Strings.nullToEmpty((String)contentTypeToUiNameEntry.getValue()).toLowerCase().contains(Strings.nullToEmpty(contentTypeUiTextSubstring).toLowerCase())).map(Map.Entry::getKey).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    public ImmutableList<Action> getActionsByUiTextSubstringIgnoreCase(String actionUiTextSubstring) {
        if (this.actionToUiName == null) {
            this.initializeActionToUiNameMap();
        }
        return this.actionToUiName.entrySet().stream().filter(actionToUiNameEntry -> Strings.nullToEmpty((String)actionToUiNameEntry.getValue()).toLowerCase().contains(Strings.nullToEmpty(actionUiTextSubstring).toLowerCase())).map(Map.Entry::getKey).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }
}

