/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.servlet;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.enhancera.accesslog.HostAppService;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.DataOption;
import com.enhancera.accesslog.common.PagedAccessRecords;
import com.enhancera.accesslog.common.RecordCriteria;
import com.enhancera.accesslog.common.config.FieldsService;
import com.enhancera.accesslog.common.data.SortParams;
import com.enhancera.accesslog.common.database.DatabaseDataOptionsProvider;
import com.enhancera.accesslog.common.eventsconfig.DefaultEventsConfigProvider;
import com.enhancera.accesslog.common.servlet.GenericHttpRequest;
import com.enhancera.accesslog.common.servlet.GenericHttpResponse;
import com.enhancera.accesslog.common.servlet.GlobalAccessServletRedirectExecutor;
import com.enhancera.accesslog.common.util.ContentTypeService;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.LicenseCheckResult;
import com.enhancera.accesslog.common.util.LicenseChecker;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.common.util.UserRedirect;
import com.enhancera.accesslog.common.util.UserUtils;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;

public class LogViewServletExecutor {
    private static final FormattingLogger log = FormattingLogger.getLogger(LogViewServletExecutor.class);
    private static final String PAGE = "page";
    private final TemplateRenderer templateRenderer;
    private final UserUtils userUtils;
    private final ContentTypeService contentTypeService;
    private final HostAppService hostAppService;
    private final LicenseChecker licenseChecker;
    private final FieldsService fieldsService;
    private final DefaultEventsConfigProvider defaultEventsConfigProvider;
    private final UserRedirect userRedirect;
    private final GlobalAccessServletRedirectExecutor globalAccessServletRedirectExecutor;

    public LogViewServletExecutor(TemplateRenderer templateRenderer, UserUtils userUtils, ContentTypeService contentTypeService, HostAppService hostAppService, LicenseChecker licenseChecker, FieldsService fieldsService, DefaultEventsConfigProvider defaultEventsConfigProvider, UserRedirect userRedirect, GlobalAccessServletRedirectExecutor globalAccessServletRedirectExecutor) {
        this.templateRenderer = templateRenderer;
        this.userUtils = userUtils;
        this.contentTypeService = contentTypeService;
        this.hostAppService = hostAppService;
        this.licenseChecker = licenseChecker;
        this.defaultEventsConfigProvider = defaultEventsConfigProvider;
        this.fieldsService = fieldsService;
        this.userRedirect = userRedirect;
        this.globalAccessServletRedirectExecutor = globalAccessServletRedirectExecutor;
    }

    public void doGet(GenericHttpRequest request, GenericHttpResponse response) throws IOException {
        try {
            String[] sortParams;
            this.globalAccessServletRedirectExecutor.redirectIfNotAccessible(request, response);
            if (this.userRedirect.redirectIfNotAllowed(request, response)) {
                return;
            }
            String pageString = request.getParameter(PAGE);
            RecordCriteria criteria = RecordCriteria.create(request);
            Long fromTime = null;
            Long toTime = null;
            if (criteria.getInterval() != null) {
                log.debug("interval %s ", criteria.getInterval());
                if (criteria.getInterval().getStartMillis() != 0L) {
                    fromTime = criteria.getInterval().getStartMillis();
                    log.debug("fromTime %s ", fromTime);
                }
                if (criteria.getInterval().getEndMillis() != Long.MAX_VALUE) {
                    toTime = criteria.getInterval().getEndMillis();
                }
            }
            SortParams parsedSortParams = RequestUtils.parseSortParams((sortParams = request.getParameterValues("sortParams")) != null ? Arrays.asList(sortParams) : null);
            parsedSortParams.revertOrderForUi();
            ArrayList<String> selectedContentIds = criteria.getContentIds() == null ? Collections.emptyList() : new ArrayList<String>(criteria.getContentIds());
            ArrayList<String> selectedActions = criteria.getActions() == null ? Collections.emptyList() : new ArrayList<String>(criteria.getActions());
            ArrayList<String> ipAddresses = criteria.getIpAddresses() == null ? Collections.emptyList() : new ArrayList<String>(criteria.getIpAddresses());
            ArrayList<String> selectedContentTypes = criteria.getContentTypes() == null ? Collections.emptyList() : new ArrayList<String>(criteria.getContentTypes());
            HashMap<String, Object> context = Maps.newHashMap();
            context.put(PAGE, NumberUtils.isDigits(pageString) ? Integer.parseInt(pageString) : PagedAccessRecords.START_PAGE);
            context.put("searchQuery", criteria.getSearchQuery());
            context.put("fromTime", fromTime);
            context.put("toTime", toTime);
            context.put("users", this.getUsers(criteria));
            context.put("ipAddresses", ipAddresses);
            context.put("selectedContentTypes", selectedContentTypes);
            context.put("contentTypes", this.contentTypeService.getAllContentTypesForUi());
            context.put("selectedContentIds", selectedContentIds);
            context.put("selectedActions", selectedActions);
            context.put("actions", Arrays.asList(Action.values()));
            context.put("sortParams", parsedSortParams);
            context.put("eventsConfigMap", this.defaultEventsConfigProvider.getAllContentTypeActionsMapForUi());
            context.put("fields", this.fieldsService.getAllSensitiveFieldsConfigurationFields());
            LicenseCheckResult licenseCheckResult = this.licenseChecker.checkLicense();
            if (!licenseCheckResult.isOk()) {
                log.error("Access logging disabled due to the following reason: %s", licenseCheckResult.getMessage());
                context.put("error", licenseCheckResult.getMessage());
            }
            response.setContentType("text/html;charset=utf-8");
            this.templateRenderer.render(this.hostAppService.getViewVelocityPath(), context, (Writer)response.getWriter());
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    private Set<DataOption> getUsers(RecordCriteria criteria) {
        Set result = null;
        Set<String> users = criteria.getUsers();
        if (users != null) {
            result = criteria.getUsers().stream().map(userKey -> {
                UserProfile userProfile = null;
                if ("<unknown>".equals(userKey)) {
                    return DatabaseDataOptionsProvider.UNKNOWN_USER_DATA_OPTION;
                }
                userProfile = this.userUtils.getUserProfile(new UserKey(userKey));
                String username = null;
                if (userProfile != null) {
                    username = userProfile.getUsername();
                }
                return DataOption.create(userKey, username);
            }).collect(Collectors.toSet());
        }
        return result;
    }
}

