/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.rest;

import com.atlassian.sal.api.user.UserKey;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.CommonContentType;
import com.enhancera.accesslog.common.RecordCriteria;
import com.enhancera.accesslog.common.config.ConfigService;
import com.enhancera.accesslog.common.database.DataLayer;
import com.enhancera.accesslog.common.eventsconfig.DefaultEventsConfigProvider;
import com.enhancera.accesslog.common.logwriters.AccessLogWriter;
import com.enhancera.accesslog.common.rest.ServiceResponse;
import com.enhancera.accesslog.common.servlet.GenericHttpRequest;
import com.enhancera.accesslog.common.servlet.IpResolver;
import com.enhancera.accesslog.common.util.DefaultAuditLogger;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.common.util.UserUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.joda.time.DateTime;

public class AccessLogRestResourceExecutor {
    private static final FormattingLogger log = FormattingLogger.getLogger(AccessLogRestResourceExecutor.class);
    private static final String USER_IS_NOT_AUTHORIZED = "User %s is not authorized to view accesslog.";
    private final DataLayer dataLayer;
    private final UserUtils userUtils;
    private final ConfigService configService;
    private final DefaultAuditLogger defaultAuditLogger;
    private final AccessLogWriter accessLogWriter;
    private final DefaultEventsConfigProvider defaultEventsConfigProvider;
    private final IpResolver ipResolver;

    public AccessLogRestResourceExecutor(DataLayer dataLayer, ConfigService configService, UserUtils userUtils, DefaultAuditLogger defaultAuditLogger, AccessLogWriter accessLogWriter, DefaultEventsConfigProvider defaultEventsConfigProvider, IpResolver ipResolver) {
        this.dataLayer = dataLayer;
        this.configService = configService;
        this.userUtils = userUtils;
        this.defaultAuditLogger = defaultAuditLogger;
        this.accessLogWriter = accessLogWriter;
        this.defaultEventsConfigProvider = defaultEventsConfigProvider;
        this.ipResolver = ipResolver;
    }

    public ServiceResponse getLog(Integer page, String query, List<String> sortParams, List<String> users, Long fromTime, Long toTime, List<String> ipAddresses, List<String> contentTypes, List<String> contentIds, List<String> actions) {
        if (!this.userUtils.isAdmin()) {
            log.error(USER_IS_NOT_AUTHORIZED, this.userUtils.getUserNameOrUnknown(this.userUtils.getRemoteUserKey()));
            return ServiceResponse.serverError().status(403).build();
        }
        return ServiceResponse.ok().entity(this.dataLayer.readPagedRecords(RecordCriteria.create(query, users, fromTime, toTime, ipAddresses, this.defaultEventsConfigProvider.parseContentTypesFromUi(contentTypes), contentIds, actions), page, RequestUtils.parseSortParams(sortParams), this.configService.getConfig().getNumberOfRecordsPerPage())).build();
    }

    public ServiceResponse delete(GenericHttpRequest request) {
        UserKey userKey = this.userUtils.getRemoteUserKey();
        String ipAddress = this.ipResolver.extractIpAddress(request);
        if (!this.userUtils.isAdmin()) {
            log.error(USER_IS_NOT_AUTHORIZED, this.userUtils.getUserNameOrUnknown(userKey));
            return ServiceResponse.serverError().status(403).build();
        }
        log.info("Deleting all stored log entities", new Object[0]);
        this.dataLayer.deleteAllRecords(() -> this.logDeleteEvent(userKey, ipAddress));
        this.defaultAuditLogger.logRecordsDeletedEvent(userKey, ipAddress);
        return ServiceResponse.ok().build();
    }

    private void logDeleteEvent(UserKey userKey, String ipAddress) {
        AccessRecord accessRecord = AccessRecord.create(DateTime.now(), UserUtils.getUserKeyStr(userKey), ipAddress, CommonContentType.ACCESS_LOG_PLUGIN_EVENT, "-1", "Access log", Action.DELETE);
        this.accessLogWriter.write(ImmutableList.of(accessRecord));
    }
}

