/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.logwriters;

import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.AccessRecordFormatter;
import com.enhancera.accesslog.common.config.Config;
import com.enhancera.accesslog.common.config.ConfigService;
import com.enhancera.accesslog.common.logwriters.AccessLogWriter;
import com.enhancera.accesslog.common.util.FileUtils;
import com.enhancera.accesslog.common.util.FormattingLogger;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class FileAccessLogWriter
implements AccessLogWriter {
    private static final FormattingLogger log = FormattingLogger.getLogger(FileAccessLogWriter.class);
    private final ConfigService configService;
    private final AccessRecordFormatter accessRecordFormatter;

    public FileAccessLogWriter(ConfigService configService, AccessRecordFormatter accessRecordFormatter) {
        this.configService = configService;
        this.accessRecordFormatter = accessRecordFormatter;
    }

    @Override
    public void write(List<AccessRecord> records) {
        Config config = this.configService.getConfig();
        if (config.isWriteToFile()) {
            Path path = Paths.get(config.getFilePath(), new String[0]);
            records.forEach(record -> {
                try {
                    FileUtils.writeToFile(this.accessRecordFormatter.format((AccessRecord)record) + System.lineSeparator(), path);
                }
                catch (IOException e) {
                    log.error(e, "Error writing access record to the file: " + path, new Object[0]);
                }
            });
        }
    }
}

