/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.ao.upgrade.v1;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.ao.AccessRecordEntity;
import com.enhancera.accesslog.common.ao.upgrade.UpgradeTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.DoubleConsumer;
import net.java.ao.Query;

public final class ActionFieldEntityUpgradeTaskImpl
implements UpgradeTask {
    private final ActiveObjects ao;
    private final TransactionTemplate transactionTemplate;

    public ActionFieldEntityUpgradeTaskImpl(ActiveObjects ao, TransactionTemplate transactionTemplate) {
        this.ao = ao;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public void execute(DoubleConsumer progressTracker) {
        this.transactionTemplate.execute(() -> {
            this.ao.migrate(new Class[]{AccessRecordEntity.class});
            return null;
        });
        Query pagedQuery = Query.select().where("ACTION IS NULL", new Object[0]).limit(999);
        int accessRecordCount = (Integer)this.transactionTemplate.execute(() -> this.ao.count(AccessRecordEntity.class, pagedQuery));
        if (accessRecordCount == 0) {
            return;
        }
        AtomicInteger processed = new AtomicInteger();
        AtomicInteger recordEntitiesLength = new AtomicInteger();
        do {
            this.transactionTemplate.execute(() -> {
                AccessRecordEntity[] recordEntities;
                for (AccessRecordEntity entity : recordEntities = (AccessRecordEntity[])this.ao.find(AccessRecordEntity.class, pagedQuery)) {
                    entity.setAction(Action.VIEW.name());
                    entity.setSearchableString(entity.getSearchableString() + "|" + Action.VIEW.name().toLowerCase());
                    entity.save();
                    processed.getAndIncrement();
                }
                progressTracker.accept((double)processed.get() / (double)accessRecordCount);
                recordEntitiesLength.set(recordEntities.length);
                return null;
            });
        } while (recordEntitiesLength.get() == 999);
    }
}

