/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.ao.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.enhancera.accesslog.common.ao.upgrade.UpgradeStatus;
import com.enhancera.accesslog.common.ao.upgrade.UpgradeStatusDao;
import com.enhancera.accesslog.common.ao.upgrade.UpgradeTask;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class UpgradeTaskQueue {
    private static final Logger log = Logger.getLogger(UpgradeTaskQueue.class);
    private final TransactionTemplate transactionTemplate;

    public UpgradeTaskQueue(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void queueUpgradeTask(Class<? extends UpgradeTask> upgradeTask, ActiveObjects ao) {
        log.debug((Object)("Queuing upgrade task " + upgradeTask.getName()));
        UpgradeStatusDao upgradeStatusDao = new UpgradeStatusDao(ao, this.transactionTemplate);
        ArrayList<String> queuedTasks = new ArrayList<String>();
        UpgradeStatus stored = upgradeStatusDao.load();
        if (stored != null) {
            queuedTasks.addAll(stored.getQueued());
        }
        queuedTasks.add(upgradeTask.getName());
        upgradeStatusDao.save(new UpgradeStatus(queuedTasks));
    }
}

