/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.util;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.enhancera.accesslog.common.util.UserUtils;
import java.io.IOException;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UserRedirect {
    private final LoginUriProvider loginUriProvider;
    private final UserUtils userUtils;

    public UserRedirect(LoginUriProvider loginUriProvider, UserUtils userUtils) {
        this.loginUriProvider = loginUriProvider;
        this.userUtils = userUtils;
    }

    public void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    public boolean redirectIfNotAllowed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.userUtils.getRemoteUserProfile() == null) {
            this.redirectToLogin(request, response);
            return true;
        }
        if (!this.userUtils.isAdmin()) {
            response.sendError(403);
            return true;
        }
        return false;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

