/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.enhancera.accesslog.common.access.ProgressTrackingGlobalAccessService;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.UserUtils;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/access")
@AdminOnly
public class AccessBlockingTaskProgressResource {
    private static final FormattingLogger log = FormattingLogger.getLogger(AccessBlockingTaskProgressResource.class);
    private final ProgressTrackingGlobalAccessService accessService;
    private final UserUtils userUtils;

    public AccessBlockingTaskProgressResource(ProgressTrackingGlobalAccessService accessService, UserUtils userUtils) {
        this.accessService = accessService;
        this.userUtils = userUtils;
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@Context HttpServletRequest request) {
        if (!this.userUtils.isAdmin()) {
            log.error("User %s is not authorized access this resource.", this.userUtils.getRemoteUserKey());
            return Response.serverError().status(403).build();
        }
        return Response.ok((Object)this.accessService.accessBlockingTaskProgress()).build();
    }
}

