/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.config;

import com.atlassian.sal.api.user.UserKey;
import com.enhancera.accesslog.common.config.Config;
import com.enhancera.accesslog.common.config.ConfigService;
import com.enhancera.accesslog.common.database.DataLayer;
import com.enhancera.accesslog.common.util.DefaultAuditLogger;
import com.enhancera.accesslog.common.util.FormattingLogger;

public class ConfigUpdateService {
    private static final FormattingLogger log = FormattingLogger.getLogger(ConfigUpdateService.class);
    private final ConfigService configService;
    private final DataLayer dataLayer;
    private final DefaultAuditLogger defaultAuditLogger;

    public ConfigUpdateService(ConfigService configService, DataLayer dataLayer, DefaultAuditLogger defaultAuditLogger) {
        this.configService = configService;
        this.dataLayer = dataLayer;
        this.defaultAuditLogger = defaultAuditLogger;
    }

    public void updateConfig(Config newConfig, UserKey userKey, String ipAddress) {
        this.defaultAuditLogger.logConfigUpdateRecord(userKey, newConfig, this.configService.getConfig(), ipAddress);
        this.configService.setConfig(newConfig);
        log.debug("Set retention period to %d, number of records per page to %d", newConfig.getRetentionPeriod(), newConfig.getNumberOfRecordsPerPage());
        this.dataLayer.deleteOldRecords();
    }
}

