/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.listener;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.attachment.AttachmentTrashedEvent;
import com.atlassian.confluence.event.events.content.attachment.GeneralAttachmentCreateEvent;
import com.atlassian.confluence.event.events.content.attachment.GeneralAttachmentRemoveEvent;
import com.atlassian.confluence.event.events.content.attachment.GeneralAttachmentRestoreEvent;
import com.atlassian.confluence.event.events.content.attachment.GeneralAttachmentUpdateEvent;
import com.atlassian.confluence.event.events.content.attachment.GeneralAttachmentVersionRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostMovedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRestoreEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostTrashedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostViewEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageChildrenReorderEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.event.events.security.LoginEvent;
import com.atlassian.confluence.event.events.security.LoginFailedEvent;
import com.atlassian.confluence.event.events.security.LogoutEvent;
import com.atlassian.confluence.event.events.security.SecurityEvent;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.web.context.StaticHttpContext;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.user.UserKey;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.listener.AbstractListener;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.confluence.listener.ConfluenceSyncEventListener;
import com.enhancera.accesslog.confluence.listener.event.AsyncContentEvent;
import com.enhancera.accesslog.confluence.listener.event.AsyncSecurityEvent;
import com.enhancera.accesslog.confluence.listener.event.ConfluenceContentEntity;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

public class ConfluenceSyncEventListenerImpl
extends AbstractListener
implements ConfluenceSyncEventListener {
    private static final FormattingLogger log = FormattingLogger.getLogger(ConfluenceSyncEventListenerImpl.class);
    public static final String EVENT_NAME_ATTACHMENT_TRASHED = "attachment trashed";
    public static final String EVENT_NAME_ATTACHMENT_RESTORED = "attachment restored";
    public static final String EVENT_NAME_ATTACHMENT_REMOVED = "attachment removed";
    public static final long LOGIN_WITH_REMEMBER_ME_COOKIE_TRACKING_INTERVAL = 5000L;
    public static final long LAST_LOGIN_WITH_REMEMBER_ME_COOKIE_MAP_CLEAN_INTERVAL = 300000L;
    private Map<String, Long> lastLoginViaRememberMeCookieUserTime = new ConcurrentHashMap<String, Long>();
    private AtomicLong lastLoginViaRememberMeCookieUserTimeMapLastCleanupTime = new AtomicLong();
    private final EventPublisher eventPublisher;

    public ConfluenceSyncEventListenerImpl(EventPublisher eventPublisher) {
        super(eventPublisher);
        this.eventPublisher = eventPublisher;
    }

    @Override
    @EventListener
    public void onLoginEvent(LoginEvent loginEvent) {
        this.cleanLastLoginViaRememberMeCookieUserTimeMapByTimeInterval();
        if ("cookie".equals(loginEvent.getLoginSource()) && !this.shouldLoginWithRememberCookieBeTracked(loginEvent)) {
            return;
        }
        this.publishSecurityEvent((SecurityEvent)loginEvent, AsyncSecurityEvent.SecurityEventType.LOGIN);
    }

    private void cleanLastLoginViaRememberMeCookieUserTimeMapByTimeInterval() {
        try {
            if (this.lastLoginViaRememberMeCookieUserTime.isEmpty()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastLoginViaRememberMeCookieUserTimeMapLastCleanupTime.get() < 300000L) {
                return;
            }
            this.lastLoginViaRememberMeCookieUserTimeMapLastCleanupTime.set(currentTime);
            this.cleanLastLoginViaRememberMeCookieUserTimeMapByTimeInterval(currentTime);
        }
        catch (Exception e) {
            log.getLogger().error((Object)e, (Throwable)e);
        }
    }

    public synchronized boolean shouldLoginWithRememberCookieBeTracked(LoginEvent loginEvent) {
        String currentUsername = loginEvent.getUsername();
        long currentTimeMillis = System.currentTimeMillis();
        if (!this.lastLoginViaRememberMeCookieUserTime.containsKey(currentUsername) || currentTimeMillis - this.lastLoginViaRememberMeCookieUserTime.get(currentUsername) > 5000L) {
            this.lastLoginViaRememberMeCookieUserTime.put(currentUsername, currentTimeMillis);
            this.cleanLastLoginViaRememberMeCookieUserTimeMapByTimeInterval(currentTimeMillis);
            return true;
        }
        return false;
    }

    private synchronized void cleanLastLoginViaRememberMeCookieUserTimeMapByTimeInterval(long currentTimeMillis) {
        Iterator<Map.Entry<String, Long>> entryIterator = this.lastLoginViaRememberMeCookieUserTime.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, Long> entry = entryIterator.next();
            if (currentTimeMillis - entry.getValue() <= 5000L) continue;
            entryIterator.remove();
        }
    }

    @Override
    @EventListener
    public void onLogoutEvent(LogoutEvent logoutEvent) {
        this.cleanLastLoginViaRememberMeCookieUserTimeMapByTimeInterval();
        this.publishSecurityEvent((SecurityEvent)logoutEvent, AsyncSecurityEvent.SecurityEventType.LOGOUT);
    }

    @Override
    @EventListener
    public void onLoginFailedEvent(LoginFailedEvent loginFailedEvent) {
        this.cleanLastLoginViaRememberMeCookieUserTimeMapByTimeInterval();
        this.publishSecurityEvent((SecurityEvent)loginFailedEvent, AsyncSecurityEvent.SecurityEventType.LOGIN_FAILED);
    }

    private void publishSecurityEvent(SecurityEvent securityEvent, AsyncSecurityEvent.SecurityEventType securityEventType) {
        this.eventPublisher.publish((Object)new AsyncSecurityEvent(securityEventType, securityEvent.getUsername(), securityEvent.getRemoteIP(), securityEvent.getTimestamp()));
    }

    @Override
    @EventListener
    public void onCommentCreateEvent(CommentCreateEvent commentCreateEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("comment created", new ConfluenceContentEntity((ContentEntityObject)commentCreateEvent.getComment()), this.currentUserIp(), this.currentUserKey(), Action.CREATE));
    }

    @Override
    @EventListener
    public void onCommentUpdateEvent(CommentUpdateEvent commentUpdateEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("comment updated", new ConfluenceContentEntity((ContentEntityObject)commentUpdateEvent.getComment()), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onCommentRemoveEvent(CommentRemoveEvent commentRemoveEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("comment removed", new ConfluenceContentEntity((ContentEntityObject)commentRemoveEvent.getComment()), this.currentUserIp(), this.currentUserKey(), Action.DELETE));
    }

    @Override
    @EventListener
    public void onPageCreateEvent(PageCreateEvent pageCreateEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("page created", new ConfluenceContentEntity((ContentEntityObject)pageCreateEvent.getPage()), this.currentUserIp(), this.currentUserKey(), Action.CREATE));
    }

    @Override
    @EventListener
    public void onPageViewEvent(PageViewEvent pageViewEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("page viewed", new ConfluenceContentEntity((ContentEntityObject)pageViewEvent.getPage()), this.currentUserIp(), this.currentUserKey(), Action.VIEW));
    }

    @Override
    @EventListener
    public void onPageUpdateEvent(PageUpdateEvent pageUpdateEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("page updated", new ConfluenceContentEntity((ContentEntityObject)pageUpdateEvent.getPage()), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onPageTrashedEvent(PageTrashedEvent pageTrashedEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("page trashed", new ConfluenceContentEntity((ContentEntityObject)pageTrashedEvent.getPage()), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onPageRestoreEvent(PageRestoreEvent pageRestoreEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("page restored", new ConfluenceContentEntity((ContentEntityObject)pageRestoreEvent.getPage()), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onPageMoveEvent(PageMoveEvent pageMoveEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("page moved", new ConfluenceContentEntity((ContentEntityObject)pageMoveEvent.getPage()), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onPageChildrenReorderEvent(PageChildrenReorderEvent pageChildrenReorderEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("page children reordered", new ConfluenceContentEntity((ContentEntityObject)pageChildrenReorderEvent.getPage()), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onPageRemoveEvent(PageRemoveEvent pageRemoveEvent) {
        if (pageRemoveEvent.getPage().isDraft()) {
            return;
        }
        this.eventPublisher.publish((Object)new AsyncContentEvent("page removed", new ConfluenceContentEntity((ContentEntityObject)pageRemoveEvent.getPage()), this.currentUserIp(), this.currentUserKey(), Action.DELETE));
    }

    @Override
    @EventListener
    public void onBlogPostCreateEvent(BlogPostCreateEvent blogPostCreateEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("blog post created", new ConfluenceContentEntity((ContentEntityObject)blogPostCreateEvent.getBlogPost()), this.currentUserIp(), this.currentUserKey(), Action.CREATE));
    }

    @Override
    @EventListener
    public void onBlogPostViewEvent(BlogPostViewEvent blogPostViewEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("blog post viewed", new ConfluenceContentEntity((ContentEntityObject)blogPostViewEvent.getBlogPost()), this.currentUserIp(), this.currentUserKey(), Action.VIEW));
    }

    @Override
    @EventListener
    public void onBlogPostUpdateEvent(BlogPostUpdateEvent blogPostUpdateEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("blog post updated", new ConfluenceContentEntity((ContentEntityObject)blogPostUpdateEvent.getBlogPost()), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onBlogPostTrashedEvent(BlogPostTrashedEvent blogPostTrashedEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("blog post trashed", new ConfluenceContentEntity((ContentEntityObject)blogPostTrashedEvent.getBlogPost()), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onBlogPostRestoreEvent(BlogPostRestoreEvent blogPostRestoreEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("blog post restored", new ConfluenceContentEntity((ContentEntityObject)blogPostRestoreEvent.getBlogPost()), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onBlogPostMovedEvent(BlogPostMovedEvent blogPostMovedEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("blog post moved", new ConfluenceContentEntity((ContentEntityObject)blogPostMovedEvent.getBlogPost()), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onBlogPostRemoveEvent(BlogPostRemoveEvent blogPostRemoveEvent) {
        if (blogPostRemoveEvent.getBlogPost().isDraft()) {
            return;
        }
        this.eventPublisher.publish((Object)new AsyncContentEvent("blog post removed", new ConfluenceContentEntity((ContentEntityObject)blogPostRemoveEvent.getBlogPost()), this.currentUserIp(), this.currentUserKey(), Action.DELETE));
    }

    @Override
    @EventListener
    public void onGeneralAttachmentCreateEvent(GeneralAttachmentCreateEvent generalAttachmentCreateEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("attachment created", new ConfluenceContentEntity((ContentEntityObject)generalAttachmentCreateEvent.getAttachment()), this.currentUserIp(), this.currentUserKey(), Action.CREATE));
    }

    @Override
    @EventListener
    public void onGeneralAttachmentUpdateEvent(GeneralAttachmentUpdateEvent generalAttachmentUpdateEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("attachment updated", new ConfluenceContentEntity((ContentEntityObject)generalAttachmentUpdateEvent.getAttachment()), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onAttachmentTrashedEvent(AttachmentTrashedEvent attachmentTrashedEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent(EVENT_NAME_ATTACHMENT_TRASHED, new ConfluenceContentEntity((ContentEntityObject)attachmentTrashedEvent.getAttachment()), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onGeneralAttachmentRemoveEvent(GeneralAttachmentRemoveEvent generalAttachmentRemoveEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent(EVENT_NAME_ATTACHMENT_REMOVED, new ConfluenceContentEntity((ContentEntityObject)generalAttachmentRemoveEvent.getAttachment()), this.currentUserIp(), this.currentUserKey(), Action.DELETE));
    }

    @Override
    @EventListener
    public void onGeneralAttachmentVersionRemoveEvent(GeneralAttachmentVersionRemoveEvent generalAttachmentVersionRemoveEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("attachment version removed", new ConfluenceContentEntity((ContentEntityObject)generalAttachmentVersionRemoveEvent.getAttachment()), this.currentUserIp(), this.currentUserKey(), Action.DELETE));
    }

    @Override
    @EventListener
    public void onGeneralAttachmentRestoreEvent(GeneralAttachmentRestoreEvent generalAttachmentRestoreEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent(EVENT_NAME_ATTACHMENT_RESTORED, new ConfluenceContentEntity((ContentEntityObject)generalAttachmentRestoreEvent.getAttachment()), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Nullable
    private String currentUserIp() {
        return RequestUtils.extractIpAddress(this.currentHttpRequest()).orElse(null);
    }

    @Nullable
    private HttpServletRequest currentHttpRequest() {
        return new StaticHttpContext().getRequest();
    }

    @Nullable
    private UserKey currentUserKey() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return confluenceUser != null ? confluenceUser.getKey() : null;
    }
}

