/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.data;

import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.CommonContentType;
import com.enhancera.accesslog.common.ContentType;
import com.enhancera.accesslog.common.eventsconfig.DefaultEventsConfigProvider;
import com.enhancera.accesslog.confluence.ConfluenceContentType;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ConfluenceDefaultEventsConfigProvider
implements DefaultEventsConfigProvider {
    private final Map<ContentType, List<Action>> allContentTypeActions = this.createAllContentTypeActionsMap();
    private final Map<String, List<Action>> defaultContentTypeActions = this.createDefaultContentTypeActionsMap();

    @Override
    public Map<String, List<Action>> createDefaultContentTypeActionsMap() {
        if (this.defaultContentTypeActions != null) {
            return this.defaultContentTypeActions;
        }
        return this.createAllContentTypeActionsMap().entrySet().stream().collect(Collectors.toMap(entry -> ((ContentType)entry.getKey()).getName(), Map.Entry::getValue));
    }

    @Override
    public Map<ContentType, List<Action>> getAllContentTypeActionsMapForUi() {
        return this.createAllContentTypeActionsMap();
    }

    private Map<ContentType, List<Action>> createAllContentTypeActionsMap() {
        if (this.allContentTypeActions != null) {
            return this.allContentTypeActions;
        }
        LinkedHashMap<ContentType, List<Action>> defaultConfig = new LinkedHashMap<ContentType, List<Action>>();
        defaultConfig.put(ConfluenceContentType.PAGE, Arrays.asList(Action.VIEW, Action.CREATE, Action.UPDATE, Action.DELETE, Action.EXPORT));
        defaultConfig.put(ConfluenceContentType.BLOG_POST, Arrays.asList(Action.VIEW, Action.CREATE, Action.UPDATE, Action.DELETE, Action.EXPORT));
        defaultConfig.put(CommonContentType.COMMENT, Arrays.asList(Action.VIEW, Action.CREATE, Action.UPDATE, Action.DELETE));
        defaultConfig.put(CommonContentType.ATTACHMENT, Arrays.asList(Action.VIEW, Action.CREATE, Action.UPDATE, Action.DELETE, Action.DOWNLOAD));
        defaultConfig.put(CommonContentType.USER_EVENT, Arrays.asList(Action.USER_LOGIN, Action.USER_LOGIN_FAILED, Action.USER_LOGOUT, Action.ADMIN_ACCESS_PROVIDED_TO_USER, Action.ADMIN_ACCESS_PROVISION_TO_USER_FAILED, Action.ADMIN_ACCESS_REMOVED_FOR_USER));
        defaultConfig.put(ConfluenceContentType.SPACE, Arrays.asList(Action.EXPORT));
        defaultConfig.put(ConfluenceContentType.MACRO, Arrays.asList(Action.VIEW));
        return defaultConfig;
    }
}

