/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.config;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.enhancera.accesslog.common.config.Config;
import com.enhancera.accesslog.common.config.ConfigDao;
import com.enhancera.accesslog.common.config.ConfigService;
import com.enhancera.accesslog.common.eventsconfig.DefaultEventsConfigProvider;
import java.util.concurrent.TimeUnit;

public class CachedConfigService
extends ConfigService {
    private final CachedReference<Config> configCachedReference;

    public CachedConfigService(ConfigDao dao, DefaultEventsConfigProvider eventsConfigProvider, CacheManager cacheManager) {
        super(dao, eventsConfigProvider);
        this.configCachedReference = cacheManager.getCachedReference(CachedConfigService.class.getName() + ".config", (Supplier)new ConfigSupplier(), new CacheSettingsBuilder().flushable().expireAfterAccess(5L, TimeUnit.MINUTES).build());
    }

    @Override
    public Config getConfig() {
        return (Config)this.configCachedReference.get();
    }

    private Config getConfigNonCached() {
        return super.getConfig();
    }

    @Override
    public void setConfig(Config config) {
        super.setConfig(config);
        this.configCachedReference.reset();
    }

    private class ConfigSupplier
    implements Supplier<Config> {
        private ConfigSupplier() {
        }

        public Config get() {
            return CachedConfigService.this.getConfigNonCached();
        }
    }
}

