/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common;

import com.enhancera.accesslog.common.util.CollectionUtils;
import com.enhancera.accesslog.common.util.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.joda.time.Interval;

public class RecordCriteria {
    @Nullable
    private final String searchQuery;
    @Nullable
    private final Set<String> users;
    @Nullable
    private final Interval interval;
    @Nullable
    private final Set<String> ipAddresses;
    @Nullable
    private final Set<String> contentTypes;
    @Nullable
    private final Set<String> contentIds;
    @Nullable
    private final Set<String> actions;

    private RecordCriteria(Builder builder) {
        this.searchQuery = builder.searchQuery;
        this.users = builder.users;
        this.interval = builder.interval;
        this.ipAddresses = builder.ipAddresses;
        this.contentTypes = builder.contentTypes;
        this.contentIds = builder.contentIds;
        this.actions = builder.actions;
    }

    public static RecordCriteria create(String searchQuery) {
        return new Builder().setSearchQuery(searchQuery).build();
    }

    public static RecordCriteria create(@Nullable String searchQuery, @Nullable Iterable<String> users, @Nullable Long fromTime, @Nullable Long toTime, @Nullable Iterable<String> ipAddresses, @Nullable Iterable<String> contentTypes, @Nullable Iterable<String> contentIds, @Nullable Iterable<String> actions) {
        Builder builder = new Builder();
        builder.setSearchQuery(searchQuery);
        if (users != null) {
            builder.setUsers(users);
        }
        if (fromTime != null || toTime != null) {
            long from = fromTime == null ? 0L : fromTime;
            long to = toTime == null ? Long.MAX_VALUE : toTime;
            builder.setInterval(new Interval(from, to));
        }
        if (ipAddresses != null) {
            builder.setIpAddresses(ipAddresses);
        }
        if (contentTypes != null) {
            builder.setContentTypes(RecordCriteria.toUpperCase(contentTypes));
        }
        if (contentIds != null) {
            builder.setContentIds(contentIds);
        }
        if (actions != null) {
            builder.setActions(RecordCriteria.toUpperCase(actions));
        }
        return builder.build();
    }

    private static ImmutableSet<String> toUpperCase(Iterable<String> values) {
        HashSet<String> uppercaseValues = new HashSet<String>();
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            uppercaseValues.add(iterator.next().toUpperCase());
        }
        return ImmutableSet.copyOf(uppercaseValues);
    }

    public static RecordCriteria create(HttpServletRequest request) {
        String query = request.getParameter("query");
        String fromTimeString = request.getParameter("fromTime");
        Long fromTime = Strings.isNullOrEmpty(fromTimeString) ? null : Long.valueOf(Long.parseLong(fromTimeString));
        String toTimeString = request.getParameter("toTime");
        Long toTime = Strings.isNullOrEmpty(toTimeString) ? null : Long.valueOf(Long.parseLong(toTimeString));
        Object[] usersArray = request.getParameterValues("users");
        List<Object> users = CollectionUtils.isArrayEmptyOrNull(usersArray) ? null : Arrays.asList(usersArray);
        Object[] ipAddressesArray = request.getParameterValues("ipAddresses");
        List<Object> ipAddresses = CollectionUtils.isArrayEmptyOrNull(ipAddressesArray) ? null : Arrays.asList(ipAddressesArray);
        String[] contentTypesArray = request.getParameterValues("contentTypes");
        ImmutableList<String> contentTypes = RecordCriteria.toUpperCase(contentTypesArray);
        Object[] contentIdsArray = request.getParameterValues("contentIds");
        List<Object> contentIds = CollectionUtils.isArrayEmptyOrNull(contentIdsArray) ? null : Arrays.asList(contentIdsArray);
        String[] actionsArray = request.getParameterValues("actions");
        ImmutableList<String> actions = RecordCriteria.toUpperCase(actionsArray);
        return RecordCriteria.create(query, users, fromTime, toTime, ipAddresses, contentTypes, contentIds, actions);
    }

    private static ImmutableList<String> toUpperCase(@Nullable String[] values) {
        return values != null ? ImmutableList.copyOf(Arrays.asList(values).stream().map(String::toUpperCase).collect(Collectors.toList())) : ImmutableList.of();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isEmpty() {
        return Strings.isNullOrEmpty(this.searchQuery) && org.apache.commons.collections4.CollectionUtils.isEmpty(this.users) && org.apache.commons.collections4.CollectionUtils.isEmpty(this.ipAddresses) && org.apache.commons.collections4.CollectionUtils.isEmpty(this.contentTypes) && org.apache.commons.collections4.CollectionUtils.isEmpty(this.contentIds) && org.apache.commons.collections4.CollectionUtils.isEmpty(this.actions) && this.interval == null;
    }

    @Nullable
    public String getSearchQuery() {
        return this.searchQuery;
    }

    @Nullable
    public Interval getInterval() {
        return this.interval;
    }

    @Nullable
    public Set<String> getUsers() {
        return this.users;
    }

    @Nullable
    public Set<String> getIpAddresses() {
        return this.ipAddresses;
    }

    @Nullable
    public Set<String> getContentTypes() {
        return this.contentTypes;
    }

    @Nullable
    public Set<String> getContentIds() {
        return this.contentIds;
    }

    @Nullable
    public Set<String> getActions() {
        return this.actions;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("searchQuery", this.searchQuery).add("users", this.users).add("interval", this.interval).add("ipAddresses", this.ipAddresses).add("contentTypes", this.contentTypes).add("contentIds", this.contentIds).add("actions", this.actions).toString();
    }

    public static class Builder {
        private String searchQuery;
        private Set<String> users;
        private Interval interval;
        private Set<String> ipAddresses;
        private Set<String> contentTypes;
        private Set<String> contentIds;
        private Set<String> actions;

        public Builder setSearchQuery(String searchQuery) {
            this.searchQuery = searchQuery;
            return this;
        }

        public Builder setInterval(Interval interval) {
            this.interval = interval;
            return this;
        }

        public Builder setUsers(Iterable<String> users) {
            this.users = ImmutableSet.copyOf(users);
            return this;
        }

        public Builder setIpAddresses(Iterable<String> ipAddresses) {
            this.ipAddresses = ImmutableSet.copyOf(ipAddresses);
            return this;
        }

        public Builder setContentTypes(Iterable<String> contentTypes) {
            this.contentTypes = ImmutableSet.copyOf(contentTypes);
            return this;
        }

        public Builder setContentIds(Iterable<String> contentIds) {
            this.contentIds = ImmutableSet.copyOf(contentIds);
            return this;
        }

        public Builder setActions(Iterable<String> actions) {
            this.actions = ImmutableSet.copyOf(actions);
            return this;
        }

        public RecordCriteria build() {
            return new RecordCriteria(this);
        }
    }
}

