/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser.login;

import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.recordparser.UriMatchingParserWithSpecifiedMethods;
import com.enhancera.accesslog.confluence.util.ConfluenceWebRecordsParserUtils;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;

public class LoginRecordsParserForWebSudoAuthenticate
extends UriMatchingParserWithSpecifiedMethods {
    private static final ImmutableSet ALLOWED_RESPONSE_STATUSES = ImmutableSet.of(Integer.valueOf(200), Integer.valueOf(302));
    private ConfluenceWebRecordsParserUtils confluenceWebRecordsParserUtils;

    public LoginRecordsParserForWebSudoAuthenticate(ConfluenceWebRecordsParserUtils confluenceWebRecordsParserUtils) {
        super("/doauthenticate.action", ImmutableSet.of("POST"));
        this.confluenceWebRecordsParserUtils = confluenceWebRecordsParserUtils;
    }

    @Override
    protected ImmutableList<AccessRecord> parse(RequestData requestData, ResponseData responseData) {
        int responseStatus = responseData.getStatus();
        if (!ALLOWED_RESPONSE_STATUSES.contains(responseStatus)) {
            return ImmutableList.of();
        }
        Action action = 302 == responseData.getStatus() ? Action.ADMIN_ACCESS_PROVIDED_TO_USER : Action.ADMIN_ACCESS_PROVISION_TO_USER_FAILED;
        String userName = "<unknown>";
        ImmutableCollection userNames = responseData.getHeaders().get((Object)"X-AUSERNAME");
        if (!userNames.isEmpty()) {
            userName = (String)((ImmutableList)userNames).iterator().next();
        }
        return this.confluenceWebRecordsParserUtils.parseLoginAccessRecordsFoDoAuthenticateAction(requestData.getIpAddress(), userName, action);
    }
}

