/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence;

import com.enhancera.accesslog.common.AdditionalFilter;
import com.enhancera.accesslog.confluence.SlidesViewPreProcessingFilter;
import com.enhancera.accesslog.confluence.util.ConfluenceUriRegexp;
import com.google.common.collect.ImmutableList;
import javax.servlet.http.HttpServletRequest;

public class ConfluenceAdditionalFilter
extends AdditionalFilter {
    private static final ImmutableList<String> BODY_REQUIRING_URI_REGEXPS = ImmutableList.of(ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_REST_INLINE_COMMENT_URI);

    @Override
    public boolean isRequestSuitable(HttpServletRequest httpRequest) {
        return !httpRequest.getRequestURI().matches(httpRequest.getContextPath().concat("/plugins/servlet/pptslide")) || SlidesViewPreProcessingFilter.isRequestShouldBeProcessed(httpRequest);
    }

    @Override
    public boolean isResponseBodyRequired(HttpServletRequest httpRequest) {
        return this.isResponseBodyRequired(BODY_REQUIRING_URI_REGEXPS, httpRequest);
    }

    @Override
    public boolean isRequestBodyRequired(HttpServletRequest httpRequest) {
        return false;
    }
}

