/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.sal.api.user.UserKey;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.CommonContentType;
import com.enhancera.accesslog.common.RecordCriteria;
import com.enhancera.accesslog.common.config.ConfigService;
import com.enhancera.accesslog.common.database.DataLayer;
import com.enhancera.accesslog.common.logwriters.AccessLogWriter;
import com.enhancera.accesslog.common.util.DefaultAuditLogger;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.common.util.UserUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;

@Path(value="/log")
@AdminOnly
public class AccessLogRestResource {
    private static final FormattingLogger log = FormattingLogger.getLogger(AccessLogRestResource.class);
    private static final String USER_IS_NOT_AUTHORIZED = "User %s is not authorized to view accesslog.";
    private final DataLayer dataLayer;
    private final UserUtils userUtils;
    private final ConfigService configService;
    private final DefaultAuditLogger defaultAuditLogger;
    private final AccessLogWriter accessLogWriter;

    public AccessLogRestResource(DataLayer dataLayer, ConfigService configService, UserUtils userUtils, DefaultAuditLogger defaultAuditLogger, AccessLogWriter accessLogWriter) {
        this.dataLayer = dataLayer;
        this.configService = configService;
        this.userUtils = userUtils;
        this.defaultAuditLogger = defaultAuditLogger;
        this.accessLogWriter = accessLogWriter;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getLog(@QueryParam(value="page") Integer page, @QueryParam(value="query") String query, @QueryParam(value="sortParams") List<String> sortParams, @QueryParam(value="users") List<String> users, @QueryParam(value="fromTime") Long fromTime, @QueryParam(value="toTime") Long toTime, @QueryParam(value="ipAddresses") List<String> ipAddresses, @QueryParam(value="contentTypes") List<String> contentTypes, @QueryParam(value="contentIds") List<String> contentIds, @QueryParam(value="actions") List<String> actions) {
        if (!this.userUtils.isAdmin()) {
            log.error(USER_IS_NOT_AUTHORIZED, this.userUtils.getUserNameOrUnknown(this.userUtils.getRemoteUserKey()));
            return Response.serverError().status(403).build();
        }
        return Response.ok().entity((Object)this.dataLayer.readPagedRecords(RecordCriteria.create(query, users, fromTime, toTime, ipAddresses, contentTypes, contentIds, actions), page, RequestUtils.parseSortParams(sortParams), this.configService.getConfig().getNumberOfRecordsPerPage())).build();
    }

    @DELETE
    @ReadOnlyAccessAllowed
    public Response delete(@Context HttpServletRequest request) {
        UserKey userKey = this.userUtils.getRemoteUserKey();
        String ipAddress = RequestUtils.extractIpAddress(request).orElse(null);
        if (!this.userUtils.isAdmin()) {
            log.error(USER_IS_NOT_AUTHORIZED, this.userUtils.getUserNameOrUnknown(userKey));
            return Response.serverError().status(403).build();
        }
        log.info("Deleting all stored log entities", new Object[0]);
        this.dataLayer.deleteAllRecords(() -> this.logDeleteEvent(userKey, ipAddress));
        this.defaultAuditLogger.logRecordsDeletedEvent(userKey, ipAddress);
        return Response.ok().build();
    }

    private void logDeleteEvent(UserKey userKey, String ipAddress) {
        AccessRecord accessRecord = AccessRecord.create(DateTime.now(), UserUtils.getUserKeyStr(userKey), ipAddress, CommonContentType.ACCESS_LOG_PLUGIN_EVENT, "-1", "Access log", Action.DELETE);
        this.accessLogWriter.write(ImmutableList.of(accessRecord));
    }
}

