/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.util;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.UserUtils;
import javax.annotation.Nullable;

public class ConfluenceUserPermissionsUtils {
    private static final FormattingLogger log = FormattingLogger.getLogger(ConfluenceUserPermissionsUtils.class);
    private final PermissionManager permissionManager;
    private final UserAccessor userAccessor;
    private final UserUtils userUtils;

    public ConfluenceUserPermissionsUtils(PermissionManager permissionManager, UserAccessor userAccessor, UserUtils userUtils) {
        this.permissionManager = permissionManager;
        this.userAccessor = userAccessor;
        this.userUtils = userUtils;
    }

    public boolean isUserHasViewPermissions(@Nullable UserKey userKey, ConfluenceEntityObject contentEntityObject) {
        boolean isPermitted = this.permissionManager.hasPermission((User)this.userAccessor.getUserByKey(userKey), Permission.VIEW, (Object)contentEntityObject);
        if (!isPermitted) {
            log.debug("User %s is not allowed to see content with id %d.", this.userUtils.getUserName(userKey), contentEntityObject.getId());
        }
        return isPermitted;
    }
}

