/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.listener;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.user.UserKey;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.listener.AbstractAsyncListener;
import com.enhancera.accesslog.common.logwriters.AccessLogWriter;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.LicenseCheckResult;
import com.enhancera.accesslog.common.util.LicenseChecker;
import com.enhancera.accesslog.common.util.UserUtils;
import com.enhancera.accesslog.confluence.ConfluenceContentType;
import com.enhancera.accesslog.confluence.listener.ConfluenceAsyncEventListener;
import com.enhancera.accesslog.confluence.listener.event.AsyncContentEvent;
import com.enhancera.accesslog.confluence.listener.event.AsyncSecurityEvent;
import com.enhancera.accesslog.confluence.util.ConfluenceRecordsParserUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;

public class ConfluenceAsyncEventListenerImpl
extends AbstractAsyncListener
implements ConfluenceAsyncEventListener {
    private static final Set<String> ATTACHMENT_EVENTS_VERSION_FOR_WHICH_NOT_NEEDED = ImmutableSet.of("attachment trashed", "attachment restored", "attachment removed");
    private final AccessLogWriter accessLogWriter;
    private final LicenseChecker licenseChecker;
    private final UserAccessor userAccessor;
    private static final FormattingLogger log = FormattingLogger.getLogger(ConfluenceAsyncEventListenerImpl.class);
    private long lastReportedTime = 0L;

    public ConfluenceAsyncEventListenerImpl(EventPublisher eventPublisher, AccessLogWriter accessLogWriter, LicenseChecker licenseChecker, UserAccessor userAccessor) {
        super(eventPublisher);
        this.accessLogWriter = accessLogWriter;
        this.licenseChecker = licenseChecker;
        this.userAccessor = userAccessor;
    }

    @Override
    @EventListener
    public void onSecurityEvent(AsyncSecurityEvent asyncSecurityEvent) {
        this.processEventIfLicenseIsValid(() -> this.processEvent("security event, event type:" + asyncSecurityEvent.getSecurityEventType().name(), () -> this.accessLogWriter.write(this.createRecordsForSecurityEvent(asyncSecurityEvent))));
    }

    private ImmutableList<AccessRecord> createRecordsForSecurityEvent(AsyncSecurityEvent asyncSecurityEvent) {
        Optional<Action> action = this.getActionBySecurityEventType(asyncSecurityEvent.getSecurityEventType());
        if (!action.isPresent()) {
            return ImmutableList.of();
        }
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(asyncSecurityEvent.getUserName());
        UserKey userKey = confluenceUser != null ? confluenceUser.getKey() : null;
        String username = asyncSecurityEvent.getUserName();
        UserKey userKeyForUserColumn = null;
        AsyncSecurityEvent.SecurityEventType securityEventType = asyncSecurityEvent.getSecurityEventType();
        if (!AsyncSecurityEvent.SecurityEventType.LOGIN_FAILED.equals((Object)securityEventType)) {
            userKeyForUserColumn = userKey;
        }
        return ConfluenceRecordsParserUtils.parseAccessRecords(asyncSecurityEvent.getTimestamp(), userKeyForUserColumn, asyncSecurityEvent.getIpAddress(), ConfluenceContentType.USER_EVENT, UserUtils.getUserKeyStr(userKeyForUserColumn), username != null ? username : "<unknown>", action.get());
    }

    private Optional<Action> getActionBySecurityEventType(AsyncSecurityEvent.SecurityEventType securityEventType) {
        Action action = null;
        switch (securityEventType) {
            case LOGIN: {
                action = Action.USER_LOGIN;
                break;
            }
            case LOGOUT: {
                action = Action.USER_LOGOUT;
                break;
            }
            case LOGIN_FAILED: {
                action = Action.USER_LOGIN_FAILED;
                break;
            }
        }
        return Optional.ofNullable(action);
    }

    @Override
    @EventListener
    public void onContentEvent(AsyncContentEvent contentEvent) {
        this.processEventIfLicenseIsValid(() -> this.processEvent(contentEvent.getEventName(), () -> this.accessLogWriter.write(ConfluenceAsyncEventListenerImpl.parseContentEventRecords(contentEvent))));
    }

    private void processEventIfLicenseIsValid(Runnable runnable) {
        LicenseCheckResult licenseCheckResult = this.licenseChecker.checkLicense();
        if (licenseCheckResult.isOk()) {
            runnable.run();
        } else if (System.currentTimeMillis() - this.lastReportedTime > 300000L) {
            log.warn("Access logging disabled due to the following reason: %s", licenseCheckResult.getMessage());
            this.lastReportedTime = System.currentTimeMillis();
        }
    }

    private static ImmutableList<AccessRecord> parseContentEventRecords(AsyncContentEvent contentEvent) {
        ImmutableList<AccessRecord> result = ATTACHMENT_EVENTS_VERSION_FOR_WHICH_NOT_NEEDED.contains(contentEvent.getEventName()) ? ConfluenceRecordsParserUtils.parseAttachmentTrashedOrRestroredOrDeletedAccessRecords(contentEvent.getUserKey(), contentEvent.getIpAddress(), contentEvent.getContentEntityObject(), contentEvent.getAction()) : ConfluenceRecordsParserUtils.parseContentAccessRecords(contentEvent.getUserKey(), contentEvent.getIpAddress(), contentEvent.getContentEntityObject(), contentEvent.getAction());
        return result;
    }
}

