/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.enhancera.accesslog.common.AdditionalFilter;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.filter.MultiReadHttpServletRequest;
import com.enhancera.accesslog.common.filter.StatusExposingServletResponse;
import com.enhancera.accesslog.common.logwriters.AccessLogWriter;
import com.enhancera.accesslog.common.recordparser.RecordParserUtils;
import com.enhancera.accesslog.common.recordparser.RecordsParser;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.LicenseCheckResult;
import com.enhancera.accesslog.common.util.LicenseChecker;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.util.ContentCachingResponseWrapper;

@UnrestrictedAccess
public class EventsFilter
implements Filter {
    private long lastReportedTime = 0L;
    private static final FormattingLogger log = FormattingLogger.getLogger(EventsFilter.class);
    private static final int MIN_THREADS_NUMBER = 10;
    private static final int MAX_THREADS_NUMBER = 50;
    private static final int ADDITIONAL_THREADS_KEEP_ALIVE_TIME = 10;
    public static final ImmutableMap<String, String> PREPROCESS_EVENTS = ImmutableMap.of("/rest/(insight|assets|insight-am)/[^/]+/attachments/(?<id>\\d+)/?", "DELETE");
    private FilterConfig config;
    private final UserManager userManager;
    private final RecordsParser recordsParser;
    private final AccessLogWriter accessLogWriter;
    private final AdditionalFilter additionalFilter;
    private final LicenseChecker licenseChecker;
    private ThreadPoolExecutor threadPoolExecutor;

    public EventsFilter(UserManager userManager, @Qualifier(value="recordsParser") RecordsParser recordsParser, AccessLogWriter accessLogWriter, AdditionalFilter additionalFilter, PluginLicenseManager pluginLicenseManager, LicenseChecker licenseChecker) {
        this.userManager = userManager;
        this.recordsParser = recordsParser;
        this.accessLogWriter = accessLogWriter;
        this.additionalFilter = additionalFilter;
        this.licenseChecker = licenseChecker;
    }

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
        this.threadPoolExecutor = new ThreadPoolExecutor(10, 50, 10L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
        Thread.setDefaultUncaughtExceptionHandler((t2, e) -> log.error(e));
    }

    public void destroy() {
        this.config = null;
        this.threadPoolExecutor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            log.info("Either request or response are non-HTTP. Don't know how to deal with them, so just skipping.", new Object[0]);
            return;
        }
        Object httpRequest = (HttpServletRequest)request;
        Object httpResponse = (HttpServletResponse)response;
        boolean isRequestSuitable = false;
        boolean isLicenseCheckResultOk = false;
        boolean isResponseBodyRequired = false;
        String requestBody = null;
        try {
            if (this.additionalFilter.isRequestBodyRequired((HttpServletRequest)httpRequest)) {
                MultiReadHttpServletRequest multiReadHttpServletRequest = new MultiReadHttpServletRequest((HttpServletRequest)httpRequest);
                requestBody = multiReadHttpServletRequest.getBody();
                httpRequest = multiReadHttpServletRequest;
            }
            if (!(isRequestSuitable = this.additionalFilter.isRequestSuitable((HttpServletRequest)httpRequest))) {
                log.debug("Request has been intercepted but should not be processed.", new Object[0]);
                return;
            }
            LicenseCheckResult licenseCheckResult = this.licenseChecker.checkLicense();
            isLicenseCheckResultOk = licenseCheckResult.isOk();
            if (isLicenseCheckResultOk) {
                isResponseBodyRequired = this.additionalFilter.isResponseBodyRequired((HttpServletRequest)httpRequest);
                httpResponse = isResponseBodyRequired ? new ContentCachingResponseWrapper(httpResponse) : new StatusExposingServletResponse((HttpServletResponse)httpResponse);
            } else if (System.currentTimeMillis() - this.lastReportedTime > 300000L) {
                log.warn("Access logging disabled due to the following reason: %s", licenseCheckResult.getMessage());
                this.lastReportedTime = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            log.error(e, "An exception occurred when processing event.", new Object[0]);
            isRequestSuitable = false;
        }
        finally {
            boolean alreadyProcessed = false;
            if (isLicenseCheckResultOk && isRequestSuitable && this.isRequestShouldBePreprocessed((HttpServletRequest)httpRequest)) {
                alreadyProcessed = true;
                this.parseRecords(isResponseBodyRequired, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse, requestBody, true);
            }
            try {
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
            finally {
                if (isLicenseCheckResultOk && isRequestSuitable && !alreadyProcessed) {
                    this.parseRecords(isResponseBodyRequired, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse, requestBody, false);
                }
            }
        }
    }

    private boolean isRequestShouldBePreprocessed(HttpServletRequest request) {
        for (Map.Entry entry : PREPROCESS_EVENTS.entrySet()) {
            if (!RequestUtils.decode(request.getRequestURI()).matches(request.getContextPath().concat((String)entry.getKey())) || !((String)entry.getValue()).equals(request.getMethod())) continue;
            return true;
        }
        return false;
    }

    private void parseRecords(boolean isResponseBodyRequired, HttpServletRequest httpRequest, HttpServletResponse httpResponse, @Nullable String requestBody, boolean isPreprocess) {
        try {
            UserKey userKey = this.userManager.getRemoteUserKey();
            if (this.additionalFilter.isRequestSuitable(httpRequest)) {
                int responseStatus;
                RequestData requestData = RequestData.create(httpRequest, userKey, requestBody);
                String responseBody = null;
                ImmutableListMultimap<String, String> responseHeaders = ImmutableListMultimap.of();
                if (isResponseBodyRequired) {
                    ContentCachingResponseWrapper responseWrapper = (ContentCachingResponseWrapper)httpResponse;
                    responseBody = EventsFilter.getContent(responseWrapper).orElse(null);
                    responseStatus = responseWrapper.getStatusCode();
                } else {
                    StatusExposingServletResponse statusExposingServletResponse = (StatusExposingServletResponse)httpResponse;
                    responseStatus = statusExposingServletResponse.getStatusCode();
                    responseHeaders = RecordParserUtils.createResponseHeadersForEventsFilterResponse(httpRequest, statusExposingServletResponse);
                }
                ResponseData responseData = ResponseData.create(responseStatus, responseBody, responseHeaders);
                if (isPreprocess) {
                    this.accessLogWriter.write(this.recordsParser.parseRecords(requestData, responseData));
                } else {
                    this.threadPoolExecutor.execute(() -> this.accessLogWriter.write(this.recordsParser.parseRecords(requestData, responseData)));
                }
            }
        }
        catch (Exception e) {
            log.error(e, "An exception occurred when parsing records.", new Object[0]);
        }
    }

    private static Optional<String> getContent(ContentCachingResponseWrapper responseWrapper) {
        String result = null;
        try {
            result = new String(responseWrapper.getContentAsByteArray(), responseWrapper.getCharacterEncoding());
            EventsFilter.copyBodyToResponse(responseWrapper);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e, "Error while retrieving content from response.", new Object[0]);
        }
        return Optional.ofNullable(result);
    }

    private static void copyBodyToResponse(ContentCachingResponseWrapper responseWrapper) {
        try {
            Method method = responseWrapper.getClass().getDeclaredMethod("copyBodyToResponse", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)responseWrapper, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectException) {
            log.error(reflectException, "Method ContentCachingResponseWrapper.copyBodyToResponse cannot be called.", new Object[0]);
        }
    }
}

