/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsModuleMetaData;
import com.atlassian.sal.api.transaction.TransactionCallback;
import java.lang.reflect.Array;
import java.util.Map;
import net.java.ao.DBParam;
import net.java.ao.EntityStreamCallback;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class ActiveObjectsComponent {
    private final ActiveObjects ao;

    public ActiveObjectsComponent(ActiveObjects ao) {
        this.ao = ao;
    }

    public boolean allowActiveObjectsAccess() {
        return true;
    }

    public ActiveObjects activeObjects() {
        return new ActiveObjects(){

            public void migrate(Class<? extends RawEntity<?>> ... classes) {
                ActiveObjectsComponent.this.migrate(classes);
            }

            public void migrateDestructively(Class<? extends RawEntity<?>> ... classes) {
                ActiveObjectsComponent.this.migrateDestructively(classes);
            }

            public void flushAll() {
                ActiveObjectsComponent.this.flushAll();
            }

            public void flush(RawEntity<?> ... rawEntities) {
                ActiveObjectsComponent.this.flush(rawEntities);
            }

            public <T extends RawEntity<K>, K> T[] get(Class<T> aClass, K ... ks) {
                return ActiveObjectsComponent.this.get(aClass, ks);
            }

            public <T extends RawEntity<K>, K> T get(Class<T> aClass, K k) {
                return ActiveObjectsComponent.this.get(aClass, k);
            }

            public <T extends RawEntity<K>, K> T create(Class<T> aClass, DBParam ... dbParams) {
                return ActiveObjectsComponent.this.create(aClass, dbParams);
            }

            public <T extends RawEntity<K>, K> T create(Class<T> aClass, Map<String, Object> map) {
                return ActiveObjectsComponent.this.create(aClass, map);
            }

            public void delete(RawEntity<?> ... rawEntities) {
                ActiveObjectsComponent.this.delete(rawEntities);
            }

            public <K> int deleteWithSQL(Class<? extends RawEntity<K>> aClass, String s2, Object ... objects) {
                return ActiveObjectsComponent.this.deleteWithSQL(aClass, s2, objects);
            }

            public <T extends RawEntity<K>, K> T[] find(Class<T> aClass) {
                return ActiveObjectsComponent.this.find(aClass);
            }

            public <T extends RawEntity<K>, K> T[] find(Class<T> aClass, String s2, Object ... objects) {
                return ActiveObjectsComponent.this.find(aClass, s2, objects);
            }

            public <T extends RawEntity<K>, K> T[] find(Class<T> aClass, Query query) {
                return ActiveObjectsComponent.this.find(aClass, query);
            }

            public <T extends RawEntity<K>, K> T[] find(Class<T> aClass, String s2, Query query) {
                return ActiveObjectsComponent.this.find(aClass, s2, query);
            }

            public <T extends RawEntity<K>, K> T[] findWithSQL(Class<T> aClass, String s2, String s1, Object ... objects) {
                return ActiveObjectsComponent.this.findWithSQL(aClass, s2, s1, objects);
            }

            public <T extends RawEntity<K>, K> void stream(Class<T> aClass, EntityStreamCallback<T, K> entityStreamCallback) {
                ActiveObjectsComponent.this.stream(aClass, entityStreamCallback);
            }

            public <T extends RawEntity<K>, K> void stream(Class<T> aClass, Query query, EntityStreamCallback<T, K> entityStreamCallback) {
                ActiveObjectsComponent.this.stream(aClass, query, entityStreamCallback);
            }

            public <K> int count(Class<? extends RawEntity<K>> aClass) {
                return ActiveObjectsComponent.this.count(aClass);
            }

            public <K> int count(Class<? extends RawEntity<K>> aClass, String s2, Object ... objects) {
                return ActiveObjectsComponent.this.count(aClass, s2, objects);
            }

            public <K> int count(Class<? extends RawEntity<K>> aClass, Query query) {
                return ActiveObjectsComponent.this.count(aClass, query);
            }

            public <T> T executeInTransaction(TransactionCallback<T> transactionCallback) {
                return ActiveObjectsComponent.this.executeInTransaction(transactionCallback);
            }

            public ActiveObjectsModuleMetaData moduleMetaData() {
                return ActiveObjectsComponent.this.moduleMetaData();
            }
        };
    }

    public void migrate(Class<? extends RawEntity<?>> ... classes) {
        if (!this.allowActiveObjectsAccess()) {
            return;
        }
        this.ao.migrate((Class[])classes);
    }

    public void migrateDestructively(Class<? extends RawEntity<?>> ... classes) {
        if (!this.allowActiveObjectsAccess()) {
            return;
        }
        this.ao.migrateDestructively((Class[])classes);
    }

    public void flushAll() {
        if (!this.allowActiveObjectsAccess()) {
            return;
        }
        this.ao.flushAll();
    }

    public void flush(RawEntity<?> ... rawEntities) {
        if (!this.allowActiveObjectsAccess()) {
            return;
        }
        this.ao.flush(rawEntities);
    }

    public <T extends RawEntity<K>, K> T[] get(Class<T> aClass, K ... ks) {
        if (!this.allowActiveObjectsAccess()) {
            return (RawEntity[])this.emptyArray(aClass);
        }
        return this.ao.get(aClass, (Object[])ks);
    }

    public <T extends RawEntity<K>, K> T get(Class<T> aClass, K k) {
        if (!this.allowActiveObjectsAccess()) {
            return null;
        }
        return (T)this.ao.get(aClass, k);
    }

    public <T extends RawEntity<K>, K> T create(Class<T> aClass, DBParam ... dbParams) {
        if (!this.allowActiveObjectsAccess()) {
            return null;
        }
        return (T)this.ao.create(aClass, dbParams);
    }

    public <T extends RawEntity<K>, K> T create(Class<T> aClass, Map<String, Object> map) {
        if (!this.allowActiveObjectsAccess()) {
            return null;
        }
        return (T)this.ao.create(aClass, map);
    }

    public void delete(RawEntity<?> ... rawEntities) {
        if (!this.allowActiveObjectsAccess()) {
            return;
        }
        this.ao.delete(rawEntities);
    }

    public <K> int deleteWithSQL(Class<? extends RawEntity<K>> aClass, String s2, Object ... objects) {
        if (!this.allowActiveObjectsAccess()) {
            return 0;
        }
        return this.ao.deleteWithSQL(aClass, s2, objects);
    }

    public <T extends RawEntity<K>, K> T[] find(Class<T> aClass) {
        if (!this.allowActiveObjectsAccess()) {
            return (RawEntity[])this.emptyArray(aClass);
        }
        return this.ao.find(aClass);
    }

    public <T extends RawEntity<K>, K> T[] find(Class<T> aClass, String s2, Object ... objects) {
        if (!this.allowActiveObjectsAccess()) {
            return (RawEntity[])this.emptyArray(aClass);
        }
        return this.ao.find(aClass, s2, objects);
    }

    public <T extends RawEntity<K>, K> T[] find(Class<T> aClass, Query query) {
        if (!this.allowActiveObjectsAccess()) {
            return (RawEntity[])this.emptyArray(aClass);
        }
        return this.ao.find(aClass, query);
    }

    public <T extends RawEntity<K>, K> T[] find(Class<T> aClass, String s2, Query query) {
        if (!this.allowActiveObjectsAccess()) {
            return (RawEntity[])this.emptyArray(aClass);
        }
        return this.ao.find(aClass, s2, query);
    }

    public <T extends RawEntity<K>, K> T[] findWithSQL(Class<T> aClass, String s2, String s1, Object ... objects) {
        if (!this.allowActiveObjectsAccess()) {
            return (RawEntity[])this.emptyArray(aClass);
        }
        return this.ao.findWithSQL(aClass, s2, s1, objects);
    }

    public <T extends RawEntity<K>, K> void stream(Class<T> aClass, EntityStreamCallback<T, K> entityStreamCallback) {
        if (!this.allowActiveObjectsAccess()) {
            return;
        }
        this.ao.stream(aClass, entityStreamCallback);
    }

    public <T extends RawEntity<K>, K> void stream(Class<T> aClass, Query query, EntityStreamCallback<T, K> entityStreamCallback) {
        if (!this.allowActiveObjectsAccess()) {
            return;
        }
        this.ao.stream(aClass, query, entityStreamCallback);
    }

    public <K> int count(Class<? extends RawEntity<K>> aClass) {
        if (!this.allowActiveObjectsAccess()) {
            return 0;
        }
        return this.ao.count(aClass);
    }

    public <K> int count(Class<? extends RawEntity<K>> aClass, String s2, Object ... objects) {
        if (!this.allowActiveObjectsAccess()) {
            return 0;
        }
        return this.ao.count(aClass, s2, objects);
    }

    public <K> int count(Class<? extends RawEntity<K>> aClass, Query query) {
        if (!this.allowActiveObjectsAccess()) {
            return 0;
        }
        return this.ao.count(aClass, query);
    }

    public <T> T executeInTransaction(TransactionCallback<T> transactionCallback) {
        if (!this.allowActiveObjectsAccess()) {
            return null;
        }
        return (T)this.ao.executeInTransaction(transactionCallback);
    }

    public ActiveObjectsModuleMetaData moduleMetaData() {
        if (!this.allowActiveObjectsAccess()) {
            return null;
        }
        return this.ao.moduleMetaData();
    }

    private <T> T[] emptyArray(Class<T> tClass) {
        return (Object[])Array.newInstance(tClass, 0);
    }
}

