/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.util;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserKey;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.recordparser.RecordParserUtils;
import com.enhancera.accesslog.common.util.FormattingUtils;
import com.enhancera.accesslog.confluence.ConfluenceContentType;
import com.enhancera.accesslog.confluence.util.ConfluenceContentUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceRecordsParserUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class ConfluenceApiContentRecordsParserUtils {
    private final PageManager pageManager;
    private final CommentManager commentManager;
    private final AttachmentManager attachmentManager;
    private final ConfluenceContentUtils confluenceContentUtils;

    public ConfluenceApiContentRecordsParserUtils(PageManager pageManager, CommentManager commentManager, AttachmentManager attachmentManager, ConfluenceContentUtils confluenceContentUtils) {
        this.pageManager = pageManager;
        this.commentManager = commentManager;
        this.attachmentManager = attachmentManager;
        this.confluenceContentUtils = confluenceContentUtils;
    }

    public ImmutableList<AccessRecord> parseAbstractPagesAccessRecords(List<Content> abstractPagesContent, RequestData requestData) {
        return abstractPagesContent.stream().flatMap(pageContent -> this.parseAbstractPageAccessRecords((Content)pageContent, requestData).stream()).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    private ImmutableList<AccessRecord> parseAbstractPageAccessRecords(@Nullable Content pageContent, RequestData requestData) {
        ImmutableList<AccessRecord> result = ImmutableList.of();
        if (pageContent != null) {
            String contentDisplayName = this.getAbstractPageContentDisplayName(pageContent);
            result = ConfluenceRecordsParserUtils.parseAccessRecords(requestData.getUserKey(), requestData.getIpAddress(), (com.enhancera.accesslog.common.ContentType)(ContentType.BLOG_POST.equals((Object)pageContent.getType()) ? ConfluenceContentType.BLOG_POST : ConfluenceContentType.PAGE), pageContent.getId().asLong(), contentDisplayName, Action.VIEW);
        }
        return result;
    }

    public ImmutableList<AccessRecord> parseContentAccessRecords(List<Content> contents, RequestData requestData) {
        return contents.stream().flatMap(content -> this.parseContentAccessRecords((Content)content, requestData).stream()).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    private ImmutableList<AccessRecord> parseContentAccessRecords(@Nullable Content content, RequestData requestData) {
        ImmutableList<AccessRecord> result = ImmutableList.of();
        if (content != null) {
            ContentType contentType = content.getType();
            if (ContentType.COMMENT.equals((Object)content.getType())) {
                result = this.parseCommentAccessRecords(this.getAbstractPageContentDisplayName((Content)content.getContainer()), content, requestData);
            } else if (ConfluenceContentUtils.ABSTRACT_PAGE_CONTENT_TYPES.contains(contentType)) {
                result = this.parseAbstractPageAccessRecords(content, requestData);
            }
        }
        return result;
    }

    public ImmutableList<AccessRecord> parseCommentsAccessRecords(long parentContentId, List<Content> commentsContent, RequestData requestData) {
        Optional<String> pageTitle = this.getTitleByContentId(parentContentId);
        return commentsContent.stream().flatMap(commentContent -> this.parseCommentAccessRecords((String)RecordParserUtils.parseOptionalValue("title", pageTitle), (Content)commentContent, requestData).stream()).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    private Optional<String> getTitleByContentId(long contentId) {
        ContentEntityObject contentEntityObject = this.pageManager.getById(contentId);
        if (contentEntityObject == null && (contentEntityObject = this.commentManager.getById(contentId)) != null && ContentTypeEnum.COMMENT.equals((Object)contentEntityObject.getTypeEnum())) {
            return Optional.of(ConfluenceRecordsParserUtils.getAbstractPageContentDisplayName((SpaceContentEntityObject)((Comment)contentEntityObject).getContainer()));
        }
        if (contentEntityObject == null) {
            contentEntityObject = this.attachmentManager.getAttachment(contentId);
        }
        return Optional.ofNullable(contentEntityObject.getTitle());
    }

    public ImmutableList<AccessRecord> parseCommentAccessRecords(String pageTitle, Content commentContent, RequestData requestData) {
        long contentId = commentContent.getId().asLong();
        Comment comment = RecordParserUtils.parseOptionalValue(String.format("Comment can't be found by id %s.", contentId), this.confluenceContentUtils.getComment(contentId));
        return ConfluenceRecordsParserUtils.parseAccessRecords(requestData.getUserKey(), requestData.getIpAddress(), (com.enhancera.accesslog.common.ContentType)ConfluenceContentType.COMMENT, commentContent.getId().asLong(), RecordParserUtils.createCommentDisplayName(pageTitle, new DateTime(comment.getCreationDate().getTime())), Action.VIEW);
    }

    @VisibleForTesting
    public String getAbstractPageContentDisplayName(Content pageContent) {
        String contentDisplayName = pageContent.getTitle();
        if (contentDisplayName == null) {
            long abstractPageId = pageContent.getId().asLong();
            AbstractPage abstractPage = RecordParserUtils.parseOptionalValue(String.format("Neither page nor blog post can't be found by id %s.", abstractPageId), this.confluenceContentUtils.getAbstractPageById(abstractPageId));
            contentDisplayName = RecordParserUtils.createContentDisplayNameWithAuxiliaryParam(pageContent.getSpace().getKey(), FormattingUtils.formatTime(new DateTime(abstractPage.getCreationDate().getTime())));
        }
        return contentDisplayName;
    }

    public static void addUserToThreadLocal(@Nullable UserKey userKey) {
        UserAccessor userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        AuthenticatedUserThreadLocal.set((ConfluenceUser)userAccessor.getUserByKey(userKey));
    }
}

