/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.database;

import com.enhancera.accesslog.common.DataOption;
import com.enhancera.accesslog.common.DataOptionType;
import com.enhancera.accesslog.common.DataOptionsProvider;
import com.enhancera.accesslog.common.ao.AccessRecordEntity;
import com.enhancera.accesslog.common.ao.ActiveObjectsComponent;
import com.enhancera.accesslog.common.database.EntityPropertyDescriptor;
import com.enhancera.accesslog.common.util.DatabaseUtils;
import com.enhancera.accesslog.common.util.UserSearchUtils;
import java.util.HashSet;
import java.util.Set;
import net.java.ao.EntityManager;
import net.java.ao.Query;

public class DatabaseDataOptionsProvider
implements DataOptionsProvider {
    public static final int MAX_DATA_OPTIONS_COUNT = 1000;
    public static final int MAX_USER_DATA_OPTIONS_COUNT = 100;
    private static final String CONTENT_TYPE_STR = "CONTENT_TYPE";
    private static final String USER_DATA_OPTION_PROPERTY_NAME = "USER";
    private static final String IP_ADDRESS_DATA_OPTION_PROPERTY_NAME = "IP_ADDRESS";
    public static final DataOption UNKNOWN_USER_DATA_OPTION = DataOption.create("<unknown>", "<unknown>");
    public static final DataOption UNKNOWN_IP_ADDRESS_DATA_OPTION = DataOption.create("-", "-");
    private final ActiveObjectsComponent ao;
    private final DatabaseUtils databaseUtils;
    private final UserSearchUtils userSearchUtils;

    public DatabaseDataOptionsProvider(ActiveObjectsComponent ao, UserSearchUtils userSearchUtils) {
        this.ao = ao;
        this.databaseUtils = new DatabaseUtils(ao);
        this.userSearchUtils = userSearchUtils;
    }

    @Override
    public Set<DataOption> findDataOptions(DataOptionType type, String text, boolean exactMatch) {
        EntityPropertyDescriptor<String, AccessRecordEntity> descriptor;
        switch (type) {
            case USER: {
                descriptor = new EntityPropertyDescriptor<String, AccessRecordEntity>(){

                    @Override
                    public String propertyName() {
                        return DatabaseDataOptionsProvider.USER_DATA_OPTION_PROPERTY_NAME;
                    }

                    @Override
                    public String getProperty(AccessRecordEntity record) {
                        return record.getUser();
                    }
                };
                break;
            }
            case IP_ADDRESS: {
                descriptor = new EntityPropertyDescriptor<String, AccessRecordEntity>(){

                    @Override
                    public String propertyName() {
                        return DatabaseDataOptionsProvider.IP_ADDRESS_DATA_OPTION_PROPERTY_NAME;
                    }

                    @Override
                    public String getProperty(AccessRecordEntity record) {
                        return record.getIpAddress();
                    }
                };
                break;
            }
            default: {
                throw new IllegalStateException("Data options search is not implemented for type " + (Object)((Object)type));
            }
        }
        return this.getRecordFieldOptions(descriptor, text, exactMatch);
    }

    private Set<DataOption> getRecordFieldOptions(EntityPropertyDescriptor<String, AccessRecordEntity> descriptor, String param, boolean exactMatch) {
        Set<DataOption> values = new HashSet<DataOption>();
        String propertyName = descriptor.propertyName();
        param = param.toUpperCase();
        if (USER_DATA_OPTION_PROPERTY_NAME.equals(propertyName)) {
            if ("<unknown>".toUpperCase().contains(param)) {
                values.add(UNKNOWN_USER_DATA_OPTION);
            }
            values.addAll(this.userSearchUtils.findUsers(param, 100));
            return values;
        }
        if (IP_ADDRESS_DATA_OPTION_PROPERTY_NAME.equals(propertyName) && "<unknown>".toUpperCase().contains(param)) {
            values.add(UNKNOWN_IP_ADDRESS_DATA_OPTION);
            return values;
        }
        if (this.ao.count(AccessRecordEntity.class) > 0) {
            EntityManager entityManager = ((AccessRecordEntity[])this.ao.find(AccessRecordEntity.class, Query.select().limit(1)))[0].getEntityManager();
            String tableName = entityManager.getTableNameConverter().getName(AccessRecordEntity.class);
            if (exactMatch) {
                values = this.loadDataOptions(descriptor, this.createMatchQuery(exactMatch, false), tableName, propertyName, param);
            } else {
                param = param.toUpperCase();
                values = this.loadDataOptions(descriptor, this.createMatchQuery(exactMatch, true), tableName, propertyName, param);
                if (values.isEmpty()) {
                    values = this.loadDataOptions(descriptor, this.createMatchQuery(exactMatch, false), tableName, propertyName, param);
                }
            }
        }
        return values;
    }

    private Set<DataOption> loadDataOptions(EntityPropertyDescriptor<String, AccessRecordEntity> descriptor, String query, String tableName, String propertyName, String param) {
        HashSet<DataOption> values = new HashSet<DataOption>();
        int count = 0;
        for (AccessRecordEntity entity : (AccessRecordEntity[])this.ao.findWithSQL(AccessRecordEntity.class, "ID", String.format(query, tableName, propertyName, param), new Object[0])) {
            if (count++ >= 1000) break;
            String propertyValue = descriptor.getProperty(entity);
            values.add(DataOption.create(CONTENT_TYPE_STR.equals(descriptor.propertyName()) ? entity.getContentType() : propertyValue, propertyValue));
        }
        return values;
    }

    private String createMatchQuery(boolean isExactMatch, boolean isStartsWithText) {
        String result = isExactMatch ? (this.databaseUtils.isDbRequiresColumnEscaping() ? "SELECT MAX(\"ID\") AS ID FROM \"%1$s\" WHERE \"%2$s\" LIKE '%3$s%%' GROUP BY \"%2$s\"" : "SELECT MAX(ID) AS ID FROM %1$s WHERE %2$s = '%3$s' GROUP BY %2$s") : (isStartsWithText ? (this.databaseUtils.isDbRequiresColumnEscaping() ? "SELECT MAX(\"ID\") AS ID FROM \"%1$s\" WHERE UPPER(\"%2$s\") LIKE '%3$s%%' GROUP BY \"%2$s\"" : "SELECT MAX(ID) AS ID FROM %1$s WHERE UPPER(%2$s) LIKE '%3$s%%' GROUP BY %2$s") : (this.databaseUtils.isDbRequiresColumnEscaping() ? "SELECT MAX(\"ID\") AS ID FROM \"%1$s\" WHERE UPPER(\"%2$s\") LIKE '%%%3$s%%' GROUP BY \"%2$s\"" : "SELECT MAX(ID) AS ID FROM %1$s WHERE UPPER(%2$s) LIKE '%%%3$s%%' GROUP BY %2$s"));
        return result;
    }
}

