/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.data;

import com.enhancera.accesslog.common.data.SortKey;
import com.enhancera.accesslog.common.data.SortParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class SortParams {
    private SortParamsStack params = new SortParamsStack();

    public SortParams() {
    }

    public SortParams(SortParam sortParam) {
        this.put(sortParam);
    }

    public SortParams(List<SortParam> sortParams) {
        for (SortParam sortParam : sortParams) {
            this.put(sortParam);
        }
    }

    public void put(SortParam param) {
        this.params.push(param);
    }

    public List<SortParam> currentOrder() {
        return this.params.currentOrder();
    }

    public void revertOrderForUi() {
        this.params.revertOrderForUi();
    }

    public String toString() {
        return this.currentOrder().stream().map(SortParam::toString).collect(Collectors.joining(", "));
    }

    private class SortParamsStack {
        private LinkedList<SortParam> params = new LinkedList();

        private SortParamsStack() {
        }

        public void push(SortParam param) {
            this.remove(param.getKey());
            this.params.addFirst(param);
        }

        public List<SortParam> currentOrder() {
            return new ArrayList<SortParam>(this.params);
        }

        public void revertOrderForUi() {
            Collections.reverse(this.params);
        }

        private void remove(SortKey key) {
            for (SortParam p : this.params) {
                if (!p.getKey().equals((Object)key)) continue;
                this.params.remove(p);
                return;
            }
        }
    }
}

