/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common;

import com.atlassian.sal.api.user.UserKey;
import com.enhancera.accesslog.common.AutoValue_RequestData;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableListMultimap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.joda.time.DateTime;

@AutoValue
public abstract class RequestData {
    public static RequestData create(HttpServletRequest httpRequest, UserKey userKey, @Nullable String body) {
        String ipAddress = RequestUtils.extractIpAddress(httpRequest).orElse(null);
        DateTime time = DateTime.now();
        String method = httpRequest.getMethod();
        String uri = httpRequest.getRequestURI();
        String contextPath = httpRequest.getContextPath();
        String pathInfo = httpRequest.getPathInfo();
        ImmutableListMultimap<String, String> requestParameters = RequestUtils.createRequestParametersMultimap(httpRequest);
        ImmutableListMultimap<String, String> requestHeaders = RequestUtils.createRequestHeadersMultimap(httpRequest);
        return new AutoValue_RequestData(userKey, ipAddress, time, method, uri, contextPath, Optional.ofNullable(pathInfo), Optional.ofNullable(body), requestParameters, requestHeaders);
    }

    @Nullable
    public abstract UserKey getUserKey();

    public abstract String getIpAddress();

    public abstract DateTime getTime();

    public abstract String getMethod();

    public abstract String getUri();

    public abstract String getContextPath();

    public abstract Optional<String> getPathInfo();

    public abstract Optional<String> getBody();

    public abstract ImmutableListMultimap<String, String> getRequestParameters();

    public abstract ImmutableListMultimap<String, String> getRequestHeaders();

    public Optional<String> getRequestParameterValue(String parameterName) {
        return RequestUtils.getMultimapValue(this.getRequestParameters(), parameterName);
    }

    public List<String> getRequestParameterValues(String parameterName) {
        return RequestUtils.getMultimapValues(this.getRequestParameters(), parameterName);
    }

    public List<String> getRequestParameterValuesSeparatedByComma(String parameterName) {
        return RequestUtils.getMultimapValues(this.getRequestParameters(), parameterName).stream().flatMap(field -> Stream.of(Strings.nullToEmpty(field).split(","))).collect(Collectors.toList());
    }

    public Optional<String> getRequestHeaderValue(String parameterName) {
        return RequestUtils.getMultimapValue(this.getRequestHeaders(), parameterName);
    }

    public List<String> getRequestHeaderValues(String parameterName) {
        return RequestUtils.getMultimapValues(this.getRequestHeaders(), parameterName);
    }
}

