/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.util;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.ContentType;
import com.enhancera.accesslog.common.util.UserUtils;
import com.enhancera.accesslog.confluence.ConfluenceContentType;
import com.enhancera.accesslog.confluence.util.ConfluenceRecordsParserUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceUserPermissionsUtils;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class ConfluenceWebRecordsParserUtils {
    private final ConfluenceUserPermissionsUtils confluenceUserPermissionsUtils;
    private final UserAccessor userAccessor;

    public ConfluenceWebRecordsParserUtils(ConfluenceUserPermissionsUtils confluenceUserPermissionsUtils, UserAccessor userAccessor) {
        this.confluenceUserPermissionsUtils = confluenceUserPermissionsUtils;
        this.userAccessor = userAccessor;
    }

    public ImmutableList<AccessRecord> parseAbstractPageAccessRecords(UserKey userKey, String ipAddress, @Nullable AbstractPage page, Action action) {
        ImmutableList<AccessRecord> result = ImmutableList.of();
        if (page != null && this.confluenceUserPermissionsUtils.isUserHasViewPermissions(userKey, (ConfluenceEntityObject)page)) {
            result = ConfluenceRecordsParserUtils.parseAbstractPageAccessRecords(userKey, ipAddress, page, action);
        }
        return result;
    }

    public ImmutableList<AccessRecord> parseViewAbstractPageAccessRecords(UserKey userKey, String ipAddress, @Nullable AbstractPage page) {
        return this.parseAbstractPageAccessRecords(userKey, ipAddress, page, Action.VIEW);
    }

    public ImmutableList<AccessRecord> parsePageAttachmentsRecords(UserKey userKey, String ipAddress, @Nullable AbstractPage page) {
        List attachments;
        ImmutableList result = ImmutableList.of();
        List list = attachments = page != null ? page.getLatestVersionsOfAttachments() : Collections.emptyList();
        if (!attachments.isEmpty() && this.confluenceUserPermissionsUtils.isUserHasViewPermissions(userKey, (ConfluenceEntityObject)page)) {
            result = attachments.stream().flatMap(attachment -> ConfluenceRecordsParserUtils.parseAccessRecords(userKey, ipAddress, (ContentType)ConfluenceContentType.ATTACHMENT, ConfluenceRecordsParserUtils.parseAttachmentContentId(attachment), attachment.getTitle(), Action.DOWNLOAD).stream()).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
        }
        return result;
    }

    public ImmutableList<AccessRecord> parseViewAttachmentRecords(UserKey userKey, String ipAddress, @Nullable Attachment attachment) {
        return attachment != null && this.confluenceUserPermissionsUtils.isUserHasViewPermissions(userKey, (ConfluenceEntityObject)attachment) ? ConfluenceRecordsParserUtils.parseAccessRecords(userKey, ipAddress, (ContentType)ConfluenceContentType.ATTACHMENT, ConfluenceRecordsParserUtils.parseAttachmentContentId(attachment), attachment.getTitle(), Action.VIEW) : ImmutableList.of();
    }

    public ImmutableList<AccessRecord> parseExportSpaceRecord(UserKey userKey, String ipAddress, @Nullable Space space) {
        ImmutableList<AccessRecord> result = ImmutableList.of();
        if (space != null && this.confluenceUserPermissionsUtils.isUserHasViewPermissions(userKey, (ConfluenceEntityObject)space)) {
            result = ConfluenceRecordsParserUtils.parseAccessRecords(userKey, ipAddress, (ContentType)ConfluenceContentType.SPACE, space.getId(), space.getKey(), Action.EXPORT);
        }
        return result;
    }

    public ImmutableList<AccessRecord> parseLoginAccessRecordsFoDoAuthenticateAction(String ipAddress, String userName, Action action) {
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(userName);
        UserKey userKey = confluenceUser != null ? confluenceUser.getKey() : null;
        String userKeyStr = UserUtils.getUserKeyStr(userKey);
        return ImmutableList.of(AccessRecord.create(DateTime.now(), userKeyStr, ipAddress, ConfluenceContentType.USER_EVENT, userKeyStr, userName, action));
    }
}

