/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.util;

import com.enhancera.accesslog.common.config.Config;
import com.enhancera.accesslog.common.config.ConfigService;
import com.enhancera.accesslog.common.util.FormattingLogger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import javax.annotation.Nullable;
import org.apache.tika.Tika;

public class FileUtils {
    private static final FormattingLogger log = FormattingLogger.getLogger(FileUtils.class);
    public static final char UTF_BYTE_ORDER_MARK = '\ufeff';
    private static final String LOG_FILE_INIT_MESSAGE = "Access log file initialized." + System.lineSeparator();
    private final ConfigService configService;

    public FileUtils(ConfigService configService) {
        this.configService = configService;
    }

    public boolean initFile(@Nullable String pathString) {
        Config config = this.configService.getConfig();
        if (config.isWriteToFile() && config.getFilePath().equals(pathString)) {
            return true;
        }
        try {
            String initMessage = LOG_FILE_INIT_MESSAGE;
            if (pathString == null) {
                log.error("File path is null", new Object[0]);
                return false;
            }
            Path path = Paths.get(pathString, new String[0]);
            if (path.toFile().exists()) {
                Tika tika = new Tika();
                String mimeType = tika.detect(path);
                if (mimeType == null || !mimeType.equals("text/plain") && !mimeType.equals("text/x-log")) {
                    return false;
                }
            } else {
                initMessage = '\ufeff' + initMessage;
            }
            FileUtils.writeToFile(initMessage, path);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static synchronized void writeToFile(String message, Path filePath) throws IOException {
        Files.write(filePath, message.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
    }
}

