/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.recordparser;

import com.enhancera.accesslog.common.filter.StatusExposingServletResponse;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.FormattingUtils;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.util.Optional;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.joda.time.DateTime;

public final class RecordParserUtils {
    public static final String XAUSERNAME_RESPONSE_HEADER_NAME = "X-AUSERNAME";
    public static final String OS_USERNAME_REQUEST_PARAM_NAME = "os_username";
    private static final String CONFLUENCE_DO_AUTHENTICATE_ACTION_URL = "/doauthenticate.action";
    private static final String CONFLUENCE_DROP_ADMIN_ACCESS_ACTION_URL = "/(ajax/)?dropauthentication.action";
    private static final ImmutableList<String> CONFLUENCE_XAUSERNAME_HEADER_NEEDED_IN_PARSER_URLS = ImmutableList.of("/doauthenticate.action", "/(ajax/)?dropauthentication.action");
    private static final FormattingLogger log = FormattingLogger.getLogger(RecordParserUtils.class);
    public static final String CONTENT_TYPE = "contentType";
    public static final String CONTENT_ID = "contentId";
    public static final String NEW_CONTENT_DISPLAY_NAME = "contentDisplayName";
    public static final String IP_ADDRESS = "ipAddress";
    public static final String ERROR_NULL_FIELD_VALUE_PATTERN = "%s is null";
    public static final String ERROR_NO_HANDLER_FOUND_PATTERN = "No handler for field: %, value: %s found.";
    public static final String UNKNOWN_IP_ADDRESS = "-";
    public static final String UNKNOWN_VALUE = "<unknown>";
    public static final String UNKNOWN_USER = "<unknown>";
    public static final String UNKNOWN = "unknown";
    public static final String FOCUSED_COMMENT_ID = "focusedCommentId";

    public static <T> T parseOptionalValue(String fieldName, Optional<T> optionalValue) {
        T result = null;
        if (optionalValue.isPresent()) {
            result = optionalValue.get();
        } else {
            log.error(ERROR_NULL_FIELD_VALUE_PATTERN, fieldName);
        }
        return result;
    }

    public static String createCommentDisplayName(String contentKey, DateTime commentCreatedTime) {
        return RecordParserUtils.createContentDisplayNameWithAuxiliaryParam(contentKey, FormattingUtils.formatTime(commentCreatedTime));
    }

    public static String createContentDisplayNameWithAuxiliaryParam(String contentKey, String auxiliaryParam) {
        return String.valueOf(contentKey).concat(" (").concat(auxiliaryParam).concat(")");
    }

    public static ImmutableListMultimap<String, String> createResponseHeadersForEventsFilterResponse(HttpServletRequest httpServletRequest, StatusExposingServletResponse statusExposingServletResponse) {
        ImmutableListMultimap<String, String> responseHeaders = statusExposingServletResponse.getAllHeaders();
        Optional<String> userNameHeaderValueForDoAuthenticateAction = RecordParserUtils.getUserNameHeaderValueForDoAuthenticateActionRecordParserInConfluence(httpServletRequest, statusExposingServletResponse);
        if (userNameHeaderValueForDoAuthenticateAction.isPresent()) {
            ArrayListMultimap<String, String> headersTemp = ArrayListMultimap.create(responseHeaders);
            headersTemp.put(XAUSERNAME_RESPONSE_HEADER_NAME, userNameHeaderValueForDoAuthenticateAction.get());
            responseHeaders = ImmutableListMultimap.copyOf(headersTemp);
        }
        return responseHeaders;
    }

    private static Optional<String> getUserNameHeaderValueForDoAuthenticateActionRecordParserInConfluence(HttpServletRequest httpRequest, HttpServletResponseWrapper response) {
        if (!RecordParserUtils.isRequestRelatedToUrlsForWhatXausernameHeaderNeededInParser(httpRequest)) {
            return Optional.empty();
        }
        ServletResponse innerServletResponseTemp = response.getResponse();
        do {
            if (!(innerServletResponseTemp instanceof HttpServletResponse)) continue;
            HttpServletResponse httpServletResponseTemp = (HttpServletResponse)innerServletResponseTemp;
            if (httpServletResponseTemp.getHeaderNames().contains(XAUSERNAME_RESPONSE_HEADER_NAME)) {
                return Optional.ofNullable(httpServletResponseTemp.getHeader(XAUSERNAME_RESPONSE_HEADER_NAME));
            }
            if (httpServletResponseTemp instanceof HttpServletResponseWrapper) {
                HttpServletResponseWrapper httpServletResponseWrapperTemp = (HttpServletResponseWrapper)httpServletResponseTemp;
                innerServletResponseTemp = httpServletResponseWrapperTemp.getResponse();
                continue;
            }
            innerServletResponseTemp = null;
        } while (innerServletResponseTemp != null);
        return Optional.empty();
    }

    private static boolean isRequestRelatedToUrlsForWhatXausernameHeaderNeededInParser(HttpServletRequest httpRequest) {
        return CONFLUENCE_XAUSERNAME_HEADER_NEEDED_IN_PARSER_URLS.stream().anyMatch(regexp -> RequestUtils.decode(httpRequest.getRequestURI()).matches(Strings.nullToEmpty(httpRequest.getContextPath()).concat((String)regexp)));
    }

    private RecordParserUtils() {
    }
}

