/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.ao.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.enhancera.accesslog.common.ao.upgrade.UpgradeStatus;
import com.enhancera.accesslog.common.ao.upgrade.UpgradeStatusDao;
import com.enhancera.accesslog.common.ao.upgrade.UpgradeTask;
import com.enhancera.accesslog.common.ao.upgrade.UpgradeTaskManager;
import com.enhancera.accesslog.common.util.AccessLogClusterLockService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.function.DoubleConsumer;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class UpgradeService {
    private static final Logger log = Logger.getLogger(UpgradeService.class);
    private final AccessLogClusterLockService lockService;
    private final ExecutorService asyncExecutor;
    private final UpgradeTaskManager taskManager;
    private final TransactionTemplate transactionTemplate;
    private final UpgradeStatusDao upgradeDao;
    private static boolean isUpgradeCompleted = false;
    private final DoubleConsumer progressTracker = new DoubleConsumer(){

        @Override
        public void accept(double progress) {
            UpgradeStatus status = UpgradeService.this.upgradeDao.load();
            if (status == null) {
                log.error((Object)"No upgrade task in the progress");
                return;
            }
            UpgradeService.this.upgradeDao.save(new UpgradeStatus(status.getQueued(), status.isRunning(), progress));
        }
    };

    public UpgradeService(ActiveObjects ao, TransactionTemplate transactionTemplate, AccessLogClusterLockService lockService, ExecutorService asyncExecutor, UpgradeTaskManager taskManager) {
        this.lockService = lockService;
        this.asyncExecutor = asyncExecutor;
        this.taskManager = taskManager;
        this.transactionTemplate = transactionTemplate;
        this.upgradeDao = new UpgradeStatusDao(ao, transactionTemplate);
    }

    public boolean isUpgradeCompleted() {
        if (isUpgradeCompleted) {
            return true;
        }
        UpgradeStatus upgradeStatus = this.upgradeDao.load();
        if (upgradeStatus == null) {
            isUpgradeCompleted = true;
        } else if (!upgradeStatus.isRunning()) {
            this.startUpgrade();
        }
        return isUpgradeCompleted;
    }

    @Nullable
    public UpgradeStatus upgradeStatus() {
        return this.upgradeDao.load();
    }

    private void startUpgrade() {
        log.debug((Object)"Starting upgrade.");
        this.asyncExecutor.execute(() -> {
            try {
                boolean startUpgrade = this.lockService.executeWithUpgradeLock(() -> (Boolean)this.transactionTemplate.execute(() -> {
                    UpgradeStatus status = this.upgradeDao.load();
                    if (status == null) {
                        log.error((Object)"No queued upgrade tasks");
                        return false;
                    }
                    if (status.isRunning()) {
                        log.error((Object)"Upgrade task already running");
                        return false;
                    }
                    UpgradeStatus startedStatus = new UpgradeStatus(status.getQueued(), true, 0.0);
                    this.upgradeDao.save(startedStatus);
                    return true;
                }));
                if (startUpgrade) {
                    log.info((Object)"Starting Access log upgrade task.");
                    UpgradeStatus status = (UpgradeStatus)this.transactionTemplate.execute(this.upgradeDao::load);
                    if (status == null) {
                        return;
                    }
                    List<String> queuedTasks = status.getQueued();
                    for (String taskName : queuedTasks) {
                        UpgradeTask task = (UpgradeTask)this.transactionTemplate.execute(() -> this.taskManager.getTask(taskName));
                        if (task == null) {
                            log.error((Object)("No upgrade task for name " + taskName));
                            continue;
                        }
                        UpgradeStatus startedTaskStatus = new UpgradeStatus(queuedTasks, true, 0.0);
                        this.transactionTemplate.execute(() -> this.upgradeDao.save(startedTaskStatus));
                        task.execute(this.progressTracker);
                        ArrayList<String> queued = new ArrayList<String>(queuedTasks);
                        queued.remove(taskName);
                        UpgradeStatus endedTaskStatus = new UpgradeStatus(queued, true, 0.0);
                        this.transactionTemplate.execute(() -> this.upgradeDao.save(endedTaskStatus));
                    }
                    this.upgradeDao.save(null);
                    log.info((Object)"Access log upgrade task is finished.");
                }
            }
            catch (TimeoutException e) {
                log.error((Object)"Error getting lock for upgrade task execution", (Throwable)e);
            }
        });
    }
}

