/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser.rest;

import com.atlassian.confluence.api.model.content.Content;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.logwriters.AccessLogWriter;
import com.enhancera.accesslog.common.recordparser.RecordParserUtils;
import com.enhancera.accesslog.common.recordparser.UriMatchingParser;
import com.enhancera.accesslog.common.util.NumberUtils;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceApiContentRecordsParserUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceContentUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceUriRegexp;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class InlineCommentsOfContentRestViewRecordParser
extends UriMatchingParser {
    private static final String PARAM_CONTAINER_ID = "containerId";
    private static final String PARAM_ATTACHMENT_VERSION = "attachmentVersion";
    private final ConfluenceApiContentRecordsParserUtils apiContentRecordsParserUtils;
    private final ConfluenceContentUtils contentUtils;
    private final AccessLogWriter accessLogWriter;

    public InlineCommentsOfContentRestViewRecordParser(ConfluenceApiContentRecordsParserUtils apiContentRecordsParserUtils, ConfluenceContentUtils contentUtils, AccessLogWriter accessLogWriter) {
        super(ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_REST_INLINE_COMMENTS_ALL_URI);
        this.apiContentRecordsParserUtils = apiContentRecordsParserUtils;
        this.contentUtils = contentUtils;
        this.accessLogWriter = accessLogWriter;
    }

    @Override
    protected ImmutableList<AccessRecord> parse(RequestData requestData, ResponseData responseData) {
        ImmutableList<AccessRecord> records;
        ConfluenceApiContentRecordsParserUtils.addUserToThreadLocal(requestData.getUserKey());
        String contextPath = Strings.nullToEmpty(requestData.getContextPath());
        Long containerId = RecordParserUtils.parseOptionalValue(PARAM_CONTAINER_ID, this.getContainerId(requestData));
        boolean isAttachmentComments = requestData.getUri().matches(contextPath + "/rest/files/([0-9.]+|latest)/files/(?<attachmentId>\\d+)/comments/?");
        boolean isAttachmentComment = requestData.getUri().matches(contextPath + "/rest/files/([0-9.]+|latest)/files/(?<attachmentId>\\d+)/comments/(?<commentId>\\d+)/?");
        boolean isInlineComments = requestData.getUri().matches(contextPath + ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_REST_INLINE_COMMENTS_URI);
        Integer attachmentVersion = null;
        if (isAttachmentComments) {
            attachmentVersion = NumberUtils.parseInt(requestData.getRequestParameterValue(PARAM_ATTACHMENT_VERSION).orElse(null));
        }
        int startIndex = 0;
        do {
            List<Content> commentsContent = isAttachmentComments ? this.contentUtils.getAttachmentComments(containerId, startIndex, attachmentVersion) : (isAttachmentComment ? this.contentUtils.getAttachmentCommentReplies(containerId, startIndex) : this.contentUtils.getCommentsOfContent(containerId, startIndex, isInlineComments));
            records = this.apiContentRecordsParserUtils.parseCommentsAccessRecords(containerId, commentsContent, requestData);
            this.accessLogWriter.write(records);
            startIndex += 999;
        } while (records.size() == 999);
        return ImmutableList.of();
    }

    private Optional<Long> getContainerId(RequestData requestData) {
        String requestUri = requestData.getUri();
        String contextPath = Strings.nullToEmpty(requestData.getContextPath());
        Long containerId = null;
        containerId = requestUri.matches(contextPath + ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_REST_INLINE_COMMENTS_URI) ? Long.valueOf(org.apache.commons.lang3.math.NumberUtils.toLong(requestData.getRequestParameterValue(PARAM_CONTAINER_ID).orElse(null))) : (requestUri.matches(contextPath + ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_REST_COMMENT_REPLIES_URI) ? RecordParserUtils.parseOptionalValue(PARAM_CONTAINER_ID, RequestUtils.parseUriParamLong(contextPath + ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_REST_COMMENT_REPLIES_URI, requestUri, PARAM_CONTAINER_ID)) : (requestUri.matches(contextPath + "/rest/files/([0-9.]+|latest)/files/(?<attachmentId>\\d+)/comments/?") ? RecordParserUtils.parseOptionalValue("attachmentId", RequestUtils.parseUriParamLong(contextPath + "/rest/files/([0-9.]+|latest)/files/(?<attachmentId>\\d+)/comments/?", requestUri, "attachmentId")) : RecordParserUtils.parseOptionalValue("commentId", RequestUtils.parseUriParamLong(contextPath + "/rest/files/([0-9.]+|latest)/files/(?<attachmentId>\\d+)/comments/(?<commentId>\\d+)/?", requestUri, "commentId"))));
        return Optional.ofNullable(containerId);
    }
}

