/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.util;

import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.util.ActionAndContentTypeToUiNameUtils;
import com.enhancera.accesslog.common.util.FormattingUtils;

public class SearchableStringUtils {
    public static final String SEARCHABLE_STRING_SEPARATOR = "|";
    private final ActionAndContentTypeToUiNameUtils actionAndContentTypeToUiNameUtils;

    public SearchableStringUtils(ActionAndContentTypeToUiNameUtils actionAndContentTypeToUiNameUtils) {
        this.actionAndContentTypeToUiNameUtils = actionAndContentTypeToUiNameUtils;
    }

    public String createSearchableString(AccessRecord accessRecord) {
        String ipAddress = accessRecord.getIpAddress();
        if (ipAddress == null) {
            ipAddress = "-";
        }
        StringBuilder sb = new StringBuilder().append(FormattingUtils.formatTime(accessRecord.getTime())).append(SEARCHABLE_STRING_SEPARATOR).append(ipAddress).append(SEARCHABLE_STRING_SEPARATOR).append(this.actionAndContentTypeToUiNameUtils.getContentTypeUiText(accessRecord.getContentType()).toLowerCase()).append(SEARCHABLE_STRING_SEPARATOR).append(accessRecord.getContentDisplayName().toLowerCase()).append(SEARCHABLE_STRING_SEPARATOR).append(this.actionAndContentTypeToUiNameUtils.getActionUiText(accessRecord.getAction()).toLowerCase());
        return sb.toString();
    }
}

