/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.config;

import com.enhancera.accesslog.common.config.Config;
import com.enhancera.accesslog.common.config.ConfigService;
import com.enhancera.accesslog.common.database.DataLayer;
import com.enhancera.accesslog.common.util.FormattingLogger;

public class ConfigUpdateService {
    private static final FormattingLogger log = FormattingLogger.getLogger(ConfigUpdateService.class);
    private final ConfigService configService;
    private final DataLayer dataLayer;

    public ConfigUpdateService(ConfigService configService, DataLayer dataLayer) {
        this.configService = configService;
        this.dataLayer = dataLayer;
    }

    public void updateConfig(Config newConfig) {
        this.configService.setConfig(newConfig);
        log.debug("Set retention period to %d, number of records per page to %d", newConfig.getRetentionPeriod(), newConfig.getNumberOfRecordsPerPage());
        this.dataLayer.deleteOldRecords();
    }
}

