/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.listener;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.attachment.AttachmentTrashedEvent;
import com.atlassian.confluence.event.events.content.attachment.GeneralAttachmentCreateEvent;
import com.atlassian.confluence.event.events.content.attachment.GeneralAttachmentRemoveEvent;
import com.atlassian.confluence.event.events.content.attachment.GeneralAttachmentRestoreEvent;
import com.atlassian.confluence.event.events.content.attachment.GeneralAttachmentUpdateEvent;
import com.atlassian.confluence.event.events.content.attachment.GeneralAttachmentVersionRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostMovedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRestoreEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostTrashedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostViewEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageChildrenReorderEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.web.context.StaticHttpContext;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.user.UserKey;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.listener.AbstractListener;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.confluence.listener.AsyncContentEvent;
import com.enhancera.accesslog.confluence.listener.ConfluenceSyncEventListener;

public class ConfluenceSyncEventListenerImpl
extends AbstractListener
implements ConfluenceSyncEventListener {
    public static final String EVENT_NAME_ATTACHMENT_TRASHED = "attachment trashed";
    public static final String EVENT_NAME_ATTACHMENT_RESTORED = "attachment restored";
    public static final String EVENT_NAME_ATTACHMENT_REMOVED = "attachment removed";
    private final EventPublisher eventPublisher;

    public ConfluenceSyncEventListenerImpl(EventPublisher eventPublisher) {
        super(eventPublisher);
        this.eventPublisher = eventPublisher;
    }

    @Override
    @EventListener
    public void onCommentCreateEvent(CommentCreateEvent commentCreateEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("comment created", (ContentEntityObject)commentCreateEvent.getComment(), this.currentUserIp(), this.currentUserKey(), Action.CREATE));
    }

    @Override
    @EventListener
    public void onCommentUpdateEvent(CommentUpdateEvent commentUpdateEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("comment updated", (ContentEntityObject)commentUpdateEvent.getComment(), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onCommentRemoveEvent(CommentRemoveEvent commentRemoveEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("comment removed", (ContentEntityObject)commentRemoveEvent.getComment(), this.currentUserIp(), this.currentUserKey(), Action.DELETE));
    }

    @Override
    @EventListener
    public void onPageCreateEvent(PageCreateEvent pageCreateEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("page created", (ContentEntityObject)pageCreateEvent.getPage(), this.currentUserIp(), this.currentUserKey(), Action.CREATE));
    }

    @Override
    @EventListener
    public void onPageViewEvent(PageViewEvent pageViewEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("page viewed", (ContentEntityObject)pageViewEvent.getPage(), this.currentUserIp(), this.currentUserKey(), Action.VIEW));
    }

    @Override
    @EventListener
    public void onPageUpdateEvent(PageUpdateEvent pageUpdateEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("page updated", (ContentEntityObject)pageUpdateEvent.getPage(), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onPageTrashedEvent(PageTrashedEvent pageTrashedEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("page trashed", (ContentEntityObject)pageTrashedEvent.getPage(), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onPageRestoreEvent(PageRestoreEvent pageRestoreEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("page restored", (ContentEntityObject)pageRestoreEvent.getPage(), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onPageMoveEvent(PageMoveEvent pageMoveEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("page moved", (ContentEntityObject)pageMoveEvent.getPage(), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onPageChildrenReorderEvent(PageChildrenReorderEvent pageChildrenReorderEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("page children reordered", (ContentEntityObject)pageChildrenReorderEvent.getPage(), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onPageRemoveEvent(PageRemoveEvent pageRemoveEvent) {
        if (pageRemoveEvent.getPage().isDraft()) {
            return;
        }
        this.eventPublisher.publish((Object)new AsyncContentEvent("page removed", (ContentEntityObject)pageRemoveEvent.getPage(), this.currentUserIp(), this.currentUserKey(), Action.DELETE));
    }

    @Override
    @EventListener
    public void onBlogPostCreateEvent(BlogPostCreateEvent blogPostCreateEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("blog post created", (ContentEntityObject)blogPostCreateEvent.getBlogPost(), this.currentUserIp(), this.currentUserKey(), Action.CREATE));
    }

    @Override
    @EventListener
    public void onBlogPostViewEvent(BlogPostViewEvent blogPostViewEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("blog post viewed", (ContentEntityObject)blogPostViewEvent.getBlogPost(), this.currentUserIp(), this.currentUserKey(), Action.VIEW));
    }

    @Override
    @EventListener
    public void onBlogPostUpdateEvent(BlogPostUpdateEvent blogPostUpdateEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("blog post updated", (ContentEntityObject)blogPostUpdateEvent.getBlogPost(), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onBlogPostTrashedEvent(BlogPostTrashedEvent blogPostTrashedEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("blog post trashed", (ContentEntityObject)blogPostTrashedEvent.getBlogPost(), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onBlogPostRestoreEvent(BlogPostRestoreEvent blogPostRestoreEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("blog post restored", (ContentEntityObject)blogPostRestoreEvent.getBlogPost(), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onBlogPostMovedEvent(BlogPostMovedEvent blogPostMovedEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("blog post moved", (ContentEntityObject)blogPostMovedEvent.getBlogPost(), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onBlogPostRemoveEvent(BlogPostRemoveEvent blogPostRemoveEvent) {
        if (blogPostRemoveEvent.getBlogPost().isDraft()) {
            return;
        }
        this.eventPublisher.publish((Object)new AsyncContentEvent("blog post removed", (ContentEntityObject)blogPostRemoveEvent.getBlogPost(), this.currentUserIp(), this.currentUserKey(), Action.DELETE));
    }

    @Override
    @EventListener
    public void onGeneralAttachmentCreateEvent(GeneralAttachmentCreateEvent generalAttachmentCreateEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("attachment created", (ContentEntityObject)generalAttachmentCreateEvent.getAttachment(), this.currentUserIp(), this.currentUserKey(), Action.CREATE));
    }

    @Override
    @EventListener
    public void onGeneralAttachmentUpdateEvent(GeneralAttachmentUpdateEvent generalAttachmentUpdateEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("attachment updated", (ContentEntityObject)generalAttachmentUpdateEvent.getAttachment(), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onAttachmentTrashedEvent(AttachmentTrashedEvent attachmentTrashedEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent(EVENT_NAME_ATTACHMENT_TRASHED, (ContentEntityObject)attachmentTrashedEvent.getAttachment(), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    @Override
    @EventListener
    public void onGeneralAttachmentRemoveEvent(GeneralAttachmentRemoveEvent generalAttachmentRemoveEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent(EVENT_NAME_ATTACHMENT_REMOVED, (ContentEntityObject)generalAttachmentRemoveEvent.getAttachment(), this.currentUserIp(), this.currentUserKey(), Action.DELETE));
    }

    @Override
    @EventListener
    public void onGeneralAttachmentVersionRemoveEvent(GeneralAttachmentVersionRemoveEvent generalAttachmentVersionRemoveEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent("attachment version removed", (ContentEntityObject)generalAttachmentVersionRemoveEvent.getAttachment(), this.currentUserIp(), this.currentUserKey(), Action.DELETE));
    }

    @Override
    @EventListener
    public void onGeneralAttachmentRestoreEvent(GeneralAttachmentRestoreEvent generalAttachmentRestoreEvent) {
        this.eventPublisher.publish((Object)new AsyncContentEvent(EVENT_NAME_ATTACHMENT_RESTORED, (ContentEntityObject)generalAttachmentRestoreEvent.getAttachment(), this.currentUserIp(), this.currentUserKey(), Action.UPDATE));
    }

    private String currentUserIp() {
        return RequestUtils.extractIpAddress(new StaticHttpContext().getRequest());
    }

    private UserKey currentUserKey() {
        return AuthenticatedUserThreadLocal.get().getKey();
    }
}

