/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.util;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.ContentType;
import com.enhancera.accesslog.common.ao.AccessRecordEntity;
import com.enhancera.accesslog.common.rest.AccessRecordApi;
import com.enhancera.accesslog.common.util.ContentTypeService;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.FormattingUtils;
import org.joda.time.DateTime;

public class RecordApiFactory {
    private static final FormattingLogger log = FormattingLogger.getLogger(RecordApiFactory.class);
    private final ContentTypeService contentTypeService;
    private final I18nResolver i18n;
    private final UserManager userManager;

    public RecordApiFactory(ContentTypeService contentTypeService, I18nResolver i18n, UserManager userManager) {
        this.contentTypeService = contentTypeService;
        this.i18n = i18n;
        this.userManager = userManager;
    }

    public AccessRecordApi getRecordApi(AccessRecordEntity entity) {
        ContentType contentType = this.contentTypeService.createContentType(entity.getContentType());
        String contentDisplayName = entity.getNewContentDisplayName();
        String userKeyStr = entity.getUser();
        UserKey userKey = userKeyStr != null ? new UserKey(userKeyStr) : null;
        UserProfile userProfile = userKey != null ? this.userManager.getUserProfile(userKey) : null;
        String username = userProfile != null ? userProfile.getUsername() : userKeyStr;
        AccessRecordApi api = AccessRecordApi.create(FormattingUtils.formatTime(new DateTime(entity.getTime())), username, entity.getIpAddress(), this.i18n.getText(contentType.getDisplayNameProperty()), contentDisplayName, this.contentTypeService.createContentIdViewUri(contentType, entity.getContentId(), entity.getNewContentDisplayName()), this.i18n.getText(Action.valueOf(entity.getAction()).getDisplayNameProperty()));
        log.debug(api.toString(), new Object[0]);
        return api;
    }
}

