/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.recordparser;

import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.FormattingUtils;
import java.util.Optional;
import org.joda.time.DateTime;

public final class RecordParserUtils {
    private static final FormattingLogger log = FormattingLogger.getLogger(RecordParserUtils.class);
    public static final String CONTENT_TYPE = "contentType";
    public static final String CONTENT_ID = "contentId";
    public static final String NEW_CONTENT_DISPLAY_NAME = "contentDisplayName";
    public static final String IP_ADDRESS = "ipAddress";
    public static final String ERROR_NULL_FIELD_VALUE_PATTERN = "%s is null";
    public static final String ERROR_NO_HANDLER_FOUND_PATTERN = "No handler for field: %, value: %s found.";
    public static final String UNKNOWN_USER = "<unknown>";
    public static final String UNKNOWN = "unknown";
    public static final String FOCUSED_COMMENT_ID = "focusedCommentId";

    public static <T> T parseOptionalValue(String fieldName, Optional<T> optionalValue) {
        T result = null;
        if (optionalValue.isPresent()) {
            result = optionalValue.get();
        } else {
            log.error(ERROR_NULL_FIELD_VALUE_PATTERN, fieldName);
        }
        return result;
    }

    public static String createCommentDisplayName(String contentKey, DateTime commentCreatedTime) {
        return RecordParserUtils.createContentDisplayNameWithAuxiliaryParam(contentKey, FormattingUtils.formatTime(commentCreatedTime));
    }

    public static String createContentDisplayNameWithAuxiliaryParam(String contentKey, String auxiliaryParam) {
        return String.valueOf(contentKey).concat(" (").concat(auxiliaryParam).concat(")");
    }

    private RecordParserUtils() {
    }
}

